<?php
header('Content-Type: application/json');

// ▼▼▼ TU API KEY DE GOOGLE AI VA AQUÍ ▼▼▼
$apiKey = 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw'; 

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Añadir validación para los nuevos campos
if (!$data || !isset($data['main_goal']) || !isset($data['short_term_goal']) || !isset($data['medium_term_goal']) || !isset($data['long_term_goal']) || !isset($data['prior_experience']) || !isset($data['campaign_objective']) || !isset($data['has_website']) || !isset($data['other_strategies']) || !isset($data['budget']) || !isset($data['service_price'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos en la solicitud.']);
    exit;
}

$budget = floatval($data['budget']);
$service_price = floatval($data['service_price']);
$breakeven_clients = ($service_price > 0) ? ceil($budget / $service_price) : 0;

// --- PROMPT MAESTRO (v1.7 - ANÁLISIS CRÍTICO Y PERSONALIZADO) ---
$prompt = "Actúa como un coach de negocios y estratega de marketing para dueños de negocios locales. Tu objetivo es analizar la situación completa de un estudiante para darle un feedback claro, realista y un plan de acción 100% aplicable, hablando siempre en segunda persona (Tú, Tus metas...).

--- FILOSOFÍA DEL CURSO ---
El curso CLIENT3 enseña a crear un sistema predecible. Se recomienda empezar con campañas de 'Recibir Mensajes' y un presupuesto mínimo de \$5 al día (\$150 al mes) para obtener datos fiables.

--- TU TAREA ESPECÍFICA ---
Un estudiante ha definido su situación. Analiza sus datos a través del lente de la FILOSOFÍA DEL CURSO y genera un reporte estratégico.

--- DATOS DEL ESTUDIANTE ---
- Objetivo Principal: {$data['main_goal']}
- Objetivo a Corto Plazo: {$data['short_term_goal']}
- Objetivo a Mediano Plazo: {$data['medium_term_goal']}
- Objetivo a Largo Plazo: {$data['long_term_goal']}
- Experiencia Previa: {$data['prior_experience']}
- Estrategia de Campaña: {$data['campaign_objective']}
- ¿Tiene Página Web?: {$data['has_website']}
- Otras Estrategias: {$data['other_strategies']}
- Presupuesto Mensual: \${$budget}
- Precio del Servicio: \${$service_price}

--- CÁLCULOS REALIZADOS ---
- Clientes para Cubrir Inversión: {$breakeven_clients}

--- ANÁLISIS CRÍTICO Y PERSONALIZADO REQUERIDO ---
1.  **Habla Directamente al Estudiante:** Usa siempre la segunda persona ('Tus objetivos...', 'Tu presupuesto...', 'Tu plan...').
2.  **Analiza la Realidad del Presupuesto:** Si el presupuesto mensual es menor a \$150, DEBES señalar que está por debajo del mínimo recomendado de \$5 al día y que esto hará que los resultados sean muy lentos o nulos. Sé directo pero constructivo.
3.  **Analiza la Realidad del Objetivo vs. Presupuesto:** Compara la meta de clientes del 'Objetivo Principal' con el 'Presupuesto'. Si es matemáticamente irrealista (ej. conseguir 100 clientes con \$100), DEBES explicar por qué es inviable de forma clara (ej. 'Tu meta de conseguir 100 clientes con un presupuesto de \$100 significa que tendrías que conseguir cada cliente por solo \$1, lo cual es extremadamente difícil en el mercado actual...').
4.  **Basa el Plan en la Experiencia y Estrategia:** El plan de acción debe ser 100% coherente con todos los datos proporcionados.

--- FORMATO DE RESPUESTA REQUERido ---
Genera un objeto JSON con:
- 'analisis_objetivos': Un párrafo analizando la claridad de SUS metas.
- 'analisis_viabilidad': Un párrafo explicando el análisis financiero, incluyendo el punto de equilibrio y el análisis crítico de viabilidad.
- 'plan_de_accion': Un objeto con 'primer_paso', 'corto_plazo', 'mediano_plazo', y 'largo_plazo', dando un plan de acción coherente y personalizado.";

$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode(['error' => 'No se pudo obtener una respuesta de la IA.']);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'];
$generated_text = str_replace(['```json', '```'], '', $generated_text);
$final_data = json_decode(trim($generated_text), true);

if ($final_data === null || !isset($final_data['plan_de_accion'])) {
    http_response_code(500);
    echo json_encode(['error' => 'La IA devolvió un formato de JSON inválido.', 'raw_response' => $generated_text]);
    exit;
}

echo json_encode($final_data);
?>