<?php
session_start();

// --- LÓGICA DE LOGOUT ---
if (isset($_GET['logout'])) {
    $_SESSION = [];
    session_destroy();
    header('Location: admin.php');
    exit;
}

// --- VERIFICACIÓN DE SEGURIDAD ---
if (!isset($_SESSION['admin_loggedin']) || $_SESSION['admin_loggedin'] !== true) {
    header('Location: admin.php');
    exit;
}

include 'ConectAPI.php'; 

// --- OBTENER DATOS DE CONFIGURACIÓN ---
$config = ['precio_producto' => 20.00]; // Valor por defecto
$sql_config = "SELECT clave, valor FROM configuracion WHERE clave = 'precio_producto' LIMIT 1";
$result_config = $conn->query($sql_config);
if ($result_config && $result_config->num_rows > 0) {
    $row = $result_config->fetch_assoc();
    $config['precio_producto'] = $row['valor'];
}

// --- OBTENER DATOS DEL ADMINISTRADOR ---
$admin_id = $_SESSION['admin_id'] ?? 1;
$sql_admin = "SELECT nombre, email, foto_perfil FROM admins WHERE id = ?";
$stmt_admin = $conn->prepare($sql_admin);

if ($stmt_admin) {
    $stmt_admin->bind_param("i", $admin_id);
    $stmt_admin->execute();
    $result_admin = $stmt_admin->get_result();
    $admin_data = $result_admin->fetch_assoc();
    $stmt_admin->close();
} else {
    $admin_data = null; 
}

if (!$admin_data) {
    $admin_data = [
        'nombre' => 'Administrador',
        'email' => 'admin@example.com',
        'foto_perfil' => 'https://placehold.co/100x100/ffffff/1f2937?text=A'
    ];
}

$_SESSION['admin_name'] = $admin_data['nombre'];
$_SESSION['admin_photo'] = $admin_data['foto_perfil'];

// --- OBTENER DATOS DE ESTUDIANTES ---
$sql_students = "SELECT id, nombre, email, fecha_registro, fecha_expiracion FROM estudiantes ORDER BY id DESC";
$result_students = $conn->query($sql_students);
$estudiantes = [];
if ($result_students) {
    while($row = $result_students->fetch_assoc()) {
        $estudiantes[] = $row;
    }
}

// --- CÁLCULO DE MÉTRICAS ---
$total_estudiantes = count($estudiantes);
$ingresos_totales = $total_estudiantes * (float)$config['precio_producto'];
$estudiantes_activos = 0;
foreach ($estudiantes as $estudiante) {
    if (strtotime($estudiante['fecha_expiracion']) >= time()) {
        $estudiantes_activos++;
    }
}
$estudiantes_expirados = $total_estudiantes - $estudiantes_activos;

// --- PREPARACIÓN DE DATOS PARA GRÁFICO ---
$registros_por_mes = array_fill(1, 12, 0);
foreach ($estudiantes as $estudiante) {
    $mes = date('n', strtotime($estudiante['fecha_registro']));
    $registros_por_mes[$mes]++;
}
$meses_labels = json_encode(['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic']);
$registros_data = json_encode(array_values($registros_por_mes));

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard De Administrador De Estudiantes</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        :root {
            --color-primary: #07162d;
            --color-secondary: #9e1428;
            --color-highlight: #ffc857;
            --color-background: #f5f5f5;
            --color-white: #ffffff;
            --color-text: #3d3d3d;
        }
        body { 
            font-family: 'Barlow', sans-serif;
            background-color: var(--color-background);
        }
        .bg-primary { background-color: var(--color-primary); }
        .bg-secondary { background-color: var(--color-secondary); }
        .text-primary { color: var(--color-primary); }
        .text-secondary { color: var(--color-secondary); }
        .text-highlight { color: var(--color-highlight); }
        .ring-highlight:focus { ring-color: var(--color-highlight); }
        
        .modal-overlay { transition: opacity 0.3s ease; }
        .filter-btn.active { 
            background-color: var(--color-primary); 
            color: var(--color-white);
            font-weight: bold;
        }
        
        .toast-notification {
            position: fixed; top: 20px; right: 20px; z-index: 1000;
            padding: 1rem 1.5rem; border-radius: 0.5rem; color: white;
            display: flex; align-items: center; gap: 1rem;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            transform: translateX(120%);
            transition: transform 0.5s ease-in-out;
        }
        .toast-notification.show { transform: translateX(0); }
        .toast-notification.success { background-color: #28a745; }
        .toast-notification.error { background-color: #dc3545; }
        .toast-notification .close-btn {
            background: none; border: none; color: white; font-size: 1.2rem;
            cursor: pointer; padding: 0; line-height: 1;
        }
    </style>
</head>
<body>
    <div id="toastNotification" class="toast-notification">
        <i id="toastIcon" class="fas"></i>
        <span id="toastMessage"></span>
        <button id="toastCloseBtn" class="close-btn">&times;</button>
    </div>

    <div class="flex min-h-screen w-full bg-gray-100">
        <!-- BARRA LATERAL (SIDEBAR) -->
        <aside class="w-72 flex-shrink-0 bg-primary text-white p-6 hidden lg:flex flex-col">
            <!-- Perfil del Administrador -->
            <div class="flex items-center gap-4 border-b border-gray-700 pb-6">
                <img src="<?php echo htmlspecialchars($admin_data['foto_perfil']); ?>" alt="Foto de Perfil" class="w-16 h-16 rounded-full object-cover" onerror="this.onerror=null; this.src='https://placehold.co/100x100/ffffff/1f2937?text=A';">
                <div>
                    <h2 class="font-bold text-lg"><?php echo htmlspecialchars($admin_data['nombre']); ?></h2>
                    <p class="text-sm text-gray-400">Administrador</p>
                </div>
            </div>

            <!-- ***** INICIO DE CAMBIOS ***** -->
            <!-- Contenido principal de la barra lateral -->
            <!-- Se eliminó 'mb-auto' para quitar el espacio que empujaba los botones hacia abajo -->
            <div class="mt-8"> 
                <img src="Portada.jpg" alt="Portada del Ebook" class="rounded-lg shadow-lg w-full">
            </div>
            
            <!-- Acciones -->
            <!-- Se añadió 'mt-8' para crear un espacio controlado entre la imagen y los botones -->
            <div class="flex flex-col gap-3 mt-8">
            <!-- ***** FIN DE CAMBIOS ***** -->
                 <button id="addStudentBtn" class="w-full bg-secondary text-white font-bold py-3 px-4 rounded-lg hover:bg-opacity-90 transition inline-flex items-center justify-center">
                    <i class="fas fa-plus mr-2"></i>AÑADIR ESTUDIANTE
                </button>
                <button id="settingsBtn" class="w-full bg-gray-600 text-white font-bold py-3 px-4 rounded-lg hover:bg-gray-700 transition inline-flex items-center justify-center" title="Configuración">
                    <i class="fas fa-cog mr-2"></i>CONFIGURACIÓN
                </button>
                 <a href="?logout=true" class="w-full bg-gray-700 text-white font-bold py-3 px-4 rounded-lg hover:bg-opacity-90 transition inline-flex items-center justify-center" title="Cerrar Sesión">
                    <i class="fas fa-sign-out-alt mr-2"></i>SALIR
                </a>
            </div>
        </aside>

        <!-- CONTENIDO PRINCIPAL -->
        <main class="flex-1 px-6 lg:px-10 pb-10 overflow-y-auto">
            <header class="pt-8 mb-8">
                <h1 class="text-5xl font-black uppercase">
                    <span class="text-primary">Panel de</span>
                    <span class="text-secondary">Administrador</span>
                </h1>
                <p class="text-lg text-gray-600 mt-2">Gestión de estudiantes, accesos e ingresos para tu producto.</p>
            </header>
            
            <!-- KPIs -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                 <div class="bg-white p-6 rounded-2xl shadow-lg flex items-center gap-4"><div class="bg-blue-100 text-blue-600 p-4 rounded-full"><i class="fas fa-users text-xl"></i></div><div><p class="text-gray-500">Total Estudiantes</p><p class="text-3xl font-bold"><?php echo $total_estudiantes; ?></p></div></div>
                <div class="bg-white p-6 rounded-2xl shadow-lg flex items-center gap-4"><div class="bg-green-100 text-green-600 p-4 rounded-full"><i class="fas fa-dollar-sign text-xl"></i></div><div><p class="text-gray-500">Ingresos Totales</p><p class="text-3xl font-bold">$<?php echo number_format($ingresos_totales, 2); ?></p></div></div>
                <div class="bg-white p-6 rounded-2xl shadow-lg flex items-center gap-4"><div class="bg-yellow-100 text-yellow-600 p-4 rounded-full"><i class="fas fa-user-check text-xl"></i></div><div><p class="text-gray-500">Cuentas Activas</p><p class="text-3xl font-bold"><?php echo $estudiantes_activos; ?></p></div></div>
                <div class="bg-white p-6 rounded-2xl shadow-lg flex items-center gap-4"><div class="bg-red-100 text-red-600 p-4 rounded-full"><i class="fas fa-user-times text-xl"></i></div><div><p class="text-gray-500">Cuentas Expiradas</p><p class="text-3xl font-bold"><?php echo $estudiantes_expirados; ?></p></div></div>
            </div>

            <!-- Contenedor de la Tabla -->
            <div class="bg-white p-6 rounded-2xl shadow-lg w-full">
                <div class="mb-6 flex flex-col md:flex-row gap-4 items-center">
                    <div class="relative w-full md:flex-1"><input type="search" id="searchInput" placeholder="Buscar por nombre o email..." class="w-full p-3 pl-10 border rounded-lg focus:ring-2 ring-highlight"><i class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"></i></div>
                    <div class="flex gap-2"><button class="filter-btn active px-4 py-2 rounded-lg bg-gray-200" data-filter="todos">TODOS</button><button class="filter-btn px-4 py-2 rounded-lg bg-gray-200" data-filter="activo">ACTIVOS</button><button class="filter-btn px-4 py-2 rounded-lg bg-gray-200" data-filter="expirado">EXPIRADOS</button></div>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-left"><thead class="bg-gray-50"><tr><th class="p-3 font-semibold text-gray-600">ID</th><th class="p-3 font-semibold text-gray-600">Nombre</th><th class="p-3 font-semibold text-gray-600">Email</th><th class="p-3 font-semibold text-gray-600">Registro</th><th class="p-3 font-semibold text-gray-600">Expiración</th><th class="p-3 font-semibold text-gray-600">Estado</th><th class="p-3 font-semibold text-gray-600 text-center">Acciones</th></tr></thead><tbody id="studentsTableBody"><?php if (count($estudiantes) > 0): ?><?php foreach ($estudiantes as $estudiante): ?><tr class="student-row border-b hover:bg-gray-50"><td class="p-3 font-mono text-sm"><?php echo $estudiante['id']; ?></td><td class="p-3 font-semibold student-name"><?php echo htmlspecialchars($estudiante['nombre']); ?></td><td class="p-3 student-email text-gray-600"><?php echo htmlspecialchars($estudiante['email']); ?></td><td class="p-3 text-gray-600"><?php echo date('d/m/Y', strtotime($estudiante['fecha_registro'])); ?></td><td class="p-3 text-gray-600"><?php echo date('d/m/Y', strtotime($estudiante['fecha_expiracion'])); ?></td><td class="p-3 student-status"><?php $expirado = strtotime($estudiante['fecha_expiracion']) < time(); echo $expirado ? '<span class="px-2 py-1 text-xs font-semibold text-red-800 bg-red-100 rounded-full">Expirado</span>' : '<span class="px-2 py-1 text-xs font-semibold text-green-800 bg-green-100 rounded-full">Activo</span>'; ?></td><td class="p-3 text-center"><button class="text-blue-600 hover:text-blue-800 edit-btn" title="Editar" data-id="<?php echo $estudiante['id']; ?>" data-nombre="<?php echo htmlspecialchars($estudiante['nombre']); ?>" data-email="<?php echo htmlspecialchars($estudiante['email']); ?>" data-expiracion="<?php echo $estudiante['fecha_expiracion']; ?>"><i class="fas fa-edit"></i></button><button class="text-red-600 hover:text-red-800 ml-4 delete-btn" title="Eliminar" data-id="<?php echo $estudiante['id']; ?>"><i class="fas fa-trash"></i></button></td></tr><?php endforeach; ?><?php else: ?><tr class="border-b"><td colspan="7" class="text-center p-6 text-gray-500">No se encontraron estudiantes. ¡Añade el primero!</td></tr><?php endif; ?></tbody></table>
                </div>
            </div>
            <div class="bg-white p-6 rounded-2xl shadow-lg mt-8">
                <h2 class="text-2xl font-bold text-gray-800 mb-4">Crecimiento de Estudiantes</h2>
                <div class="relative h-80"><canvas id="growthChart"></canvas></div>
            </div>
        </main>
    </div>
    
    <!-- MODALES -->
    <div id="studentModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center p-4 modal-overlay"><div class="bg-white rounded-2xl shadow-lg p-8 w-full max-w-lg">
        <h2 id="modalTitle" class="text-2xl font-bold mb-6 text-gray-800">Añadir Estudiante</h2>
        <form id="studentForm"><input type="hidden" id="studentId" name="id"><div class="space-y-4"><div><label for="nombre" class="block font-semibold" >Nombre y Apellido</label><input type="text" id="nombre" name="nombre" placeholder="Ej. Sebastian Rodriguez" class="w-full mt-1 p-2 border rounded-md" required></div><div><label for="email" class="block font-semibold">Email</label><input type="email" id="email" name="email" placeholder="Ej. sebastianrod@gmail.com" class="w-full mt-1 p-2 border rounded-md" required></div>
    <div><label for="password" class="block font-semibold">Contraseña</label><input type="password" id="password" name="password" class="w-full mt-1 p-2 border rounded-md" placeholder="Dejar en blanco para no cambiar"><small class="text-gray-500">La contraseña es requerida para nuevos estudiantes.</small></div>
    <div><label for="fecha_expiracion" class="block font-semibold">Fecha de Expiración</label><input type="date" id="fecha_expiracion" name="fecha_expiracion" class="w-full mt-1 p-2 border rounded-md" required></div></div><div class="mt-8 flex justify-end space-x-4"><button type="button" id="cancelBtn" class="px-4 py-2 bg-gray-200 rounded-lg hover:bg-gray-300">CANCELAR</button><button type="submit" class="px-4 py-2 bg-primary text-white rounded-lg hover:bg-opacity-90">GUARDAR CAMBIOS</button></div></form></div></div>
    
    <div id="settingsModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center p-4 modal-overlay">
        <div class="bg-white rounded-2xl shadow-lg p-8 w-full max-w-2xl">
            <h2 class="text-2xl font-bold mb-6 text-gray-800">Configuración del Sistema</h2>
            <form id="settingsForm" enctype="multipart/form-data">
                <!-- Sección Perfil Administrador -->
                <div class="mb-8 p-4 border rounded-lg">
                    <h3 class="font-bold text-lg mb-4">Perfil del Administrador</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div><label for="admin_nombre" class="block font-semibold">Nombre</label><input type="text" id="admin_nombre" name="admin_nombre" value="<?php echo htmlspecialchars($admin_data['nombre']); ?>" class="w-full mt-1 p-2 border rounded-md"></div>
                        <div><label for="admin_email" class="block font-semibold">Email (Login)</label><input type="email" id="admin_email" name="admin_email" value="<?php echo htmlspecialchars($admin_data['email']); ?>" class="w-full mt-1 p-2 border rounded-md"></div>
                        <div><label for="admin_password" class="block font-semibold">Nueva Contraseña</label><input type="password" id="admin_password" name="admin_password" placeholder="Dejar en blanco para no cambiar" class="w-full mt-1 p-2 border rounded-md"></div>
                        <div><label for="admin_foto" class="block font-semibold">Foto de Perfil</label><input type="file" id="admin_foto" name="admin_foto" class="w-full mt-1 text-sm"></div>
                    </div>
                </div>
                <!-- Sección Finanzas -->
                <div class="p-4 border rounded-lg">
                    <h3 class="font-bold text-lg mb-4">Finanzas</h3>
                    <div><label for="precio_producto" class="block font-semibold">Precio del Producto (USD)</label><input type="number" step="0.01" id="precio_producto" name="precio_producto" value="<?php echo htmlspecialchars($config['precio_producto']); ?>" class="w-full mt-1 p-2 border rounded-md" required></div>
                </div>
                <div class="mt-8 flex justify-end space-x-4">
                    <button type="button" id="cancelSettingsBtn" class="px-4 py-2 bg-gray-200 rounded-lg hover:bg-gray-300">CANCELAR</button>
                    <button type="submit" class="px-6 py-2 bg-primary text-white font-bold rounded-lg hover:bg-opacity-90">GUARDAR TODO</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const toast = document.getElementById('toastNotification');
            const toastMessage = document.getElementById('toastMessage');
            const toastIcon = document.getElementById('toastIcon');
            const toastCloseBtn = document.getElementById('toastCloseBtn');
            let toastTimeout;

            function showToast(message, type = 'success') {
                clearTimeout(toastTimeout);
                toastMessage.textContent = message;
                toast.className = 'toast-notification';
                toast.classList.add(type === 'success' ? 'success' : 'error');
                toastIcon.className = 'fas ' + (type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle');
                toast.classList.add('show');
                toastTimeout = setTimeout(() => toast.classList.remove('show'), 5000);
            }
            toastCloseBtn.addEventListener('click', () => { clearTimeout(toastTimeout); toast.classList.remove('show'); });

            const addStudentBtn = document.getElementById('addStudentBtn');
            const studentModal = document.getElementById('studentModal');
            const cancelBtn = document.getElementById('cancelBtn');
            const modalTitle = document.getElementById('modalTitle');
            const studentForm = document.getElementById('studentForm');
            const studentIdInput = document.getElementById('studentId');
            const settingsBtn = document.getElementById('settingsBtn');
            const settingsModal = document.getElementById('settingsModal');
            const cancelSettingsBtn = document.getElementById('cancelSettingsBtn');
            const settingsForm = document.getElementById('settingsForm');

            function openModal(title, data = {}) { modalTitle.textContent = title; studentForm.reset(); studentIdInput.value = data.id || ''; document.getElementById('nombre').value = data.nombre || ''; document.getElementById('email').value = data.email || ''; document.getElementById('fecha_expiracion').value = data.expiracion ? new Date(data.expiracion).toISOString().split('T')[0] : ''; document.getElementById('password').value = ''; studentModal.classList.remove('hidden'); studentModal.classList.add('flex'); }
            function closeModal() { studentModal.classList.add('hidden'); studentModal.classList.remove('flex'); }
            addStudentBtn.addEventListener('click', () => openModal('Añadir Estudiante'));
            document.querySelectorAll('.edit-btn').forEach(button => button.addEventListener('click', () => openModal('Editar Estudiante', button.dataset)));
            cancelBtn.addEventListener('click', closeModal);
            studentModal.addEventListener('click', (e) => { if (e.target === studentModal) closeModal(); });
            
            async function handleFormSubmit(url, formData, successMessage) {
                try {
                    const response = await fetch(url, { method: 'POST', body: formData });
                    const result = await response.json();
                    if(result.success) {
                        showToast(successMessage, 'success');
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        showToast(result.message || 'Ocurrió un error.', 'error');
                    }
                } catch(error) {
                    console.error('Error:', error);
                    showToast('Hubo un error de conexión. Revisa la consola.', 'error');
                }
            }

            studentForm.addEventListener('submit', (e) => {
                e.preventDefault();
                handleFormSubmit('api/manage_student.php', new FormData(studentForm), '¡Estudiante guardado con éxito!');
            });
            
            settingsForm.addEventListener('submit', (e) => {
                e.preventDefault();
                handleFormSubmit('api/update_system_settings.php', new FormData(settingsForm), '¡Configuración guardada con éxito!');
            });

            document.querySelectorAll('.delete-btn').forEach(button => {
                button.addEventListener('click', async () => {
                    if(confirm('¿Estás seguro de que quieres eliminar a este estudiante?')) {
                        const studentId = button.dataset.id;
                        try {
                            const response = await fetch('api/delete_student.php', { method: 'POST', headers: {'Content-Type': 'application/json'}, body: JSON.stringify({ id: studentId }) });
                            const result = await response.json();
                            if(result.success) {
                                showToast('Estudiante eliminado con éxito.', 'success');
                                setTimeout(() => location.reload(), 1500);
                            } else {
                                showToast(result.message, 'error');
                            }
                        } catch(error) {
                            console.error('Error:', error);
                            showToast('Hubo un error al eliminar. Revisa la consola.', 'error');
                        }
                    }
                });
            });

            function openSettingsModal() { settingsModal.classList.remove('hidden'); settingsModal.classList.add('flex'); }
            function closeSettingsModal() { settingsModal.classList.add('hidden'); settingsModal.classList.remove('flex'); }
            settingsBtn.addEventListener('click', openSettingsModal);
            cancelSettingsBtn.addEventListener('click', closeSettingsModal);
            settingsModal.addEventListener('click', (e) => { if (e.target === settingsModal) closeSettingsModal(); });

            const ctx = document.getElementById('growthChart').getContext('2d');
            new Chart(ctx, { type: 'bar', data: { labels: <?php echo $meses_labels; ?>, datasets: [{ label: 'Nuevos Estudiantes', data: <?php echo $registros_data; ?>, backgroundColor: 'var(--color-primary)', borderColor: 'var(--color-primary)', borderWidth: 1, borderRadius: 5 }] }, options: { scales: { y: { beginAtZero: true, ticks: { stepSize: 1 } } }, responsive: true, maintainAspectRatio: false, plugins: { legend: { display: false } } } });
            const searchInput = document.getElementById('searchInput');
            const filterBtns = document.querySelectorAll('.filter-btn');
            const tableBody = document.getElementById('studentsTableBody');
            const rows = tableBody.getElementsByTagName('tr');
            function filterTable() { const searchTerm = searchInput.value.toLowerCase(); const activeFilter = document.querySelector('.filter-btn.active').dataset.filter; for (let row of rows) { const name = row.querySelector('.student-name')?.textContent.toLowerCase() || ''; const email = row.querySelector('.student-email')?.textContent.toLowerCase() || ''; const statusSpan = row.querySelector('.student-status span'); const status = statusSpan ? statusSpan.textContent.toLowerCase() : ''; const matchesSearch = name.includes(searchTerm) || email.includes(searchTerm); const matchesFilter = (activeFilter === 'todos') || (status === activeFilter); row.style.display = (matchesSearch && matchesFilter) ? '' : 'none'; } }
            searchInput.addEventListener('input', filterTable);
            filterBtns.forEach(button => button.addEventListener('click', () => {
                filterBtns.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');
                filterTable();
            }));
        });
    </script>
</body>
</html>
<?php
$conn->close();
?>