<?php
// --- INICIO DE SESIÓN SEGURO ---
// Se verifica si ya existe una sesión activa antes de iniciar una nueva.
// Esto elimina el error "A session had already been started".
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// --- GUARDIA DE SEGURIDAD PARA EL PANEL DE ADMINISTRADOR ---
// Este bloque protege cualquier archivo que incluya ConectAPI.php.
// NOTA: Este guardián es para el 'admin', no para el 'estudiante'.
if (basename($_SERVER['PHP_SELF']) !== 'admin.php' && basename($_SERVER['PHP_SELF']) !== 'index.php') {
    if (!isset($_SESSION['admin_loggedin']) || $_SESSION['admin_loggedin'] !== true) {
        
        $is_api_request = strpos($_SERVER['REQUEST_URI'], '/api/') !== false;
        
        if ($is_api_request) {
            header('Content-Type: application/json');
            http_response_code(401); 
            echo json_encode(['success' => false, 'message' => 'Acceso no autorizado.']);
            exit;
        } else {
            // Para páginas normales del admin, redirige al login de admin.
            header('Location: admin.php');
            exit;
        }
    }
}


// --- CONFIGURACIÓN DE LA CONEXIÓN ---
// REEMPLAZA ESTOS VALORES con tus credenciales reales de la base de datos.
$servername = "localhost";
$username = "orozdesign_asisecobraebook"; // Tu usuario de la base de datos
$password = "ADP3x7=21-1981@!"; // Tu contraseña de la base de datos
$dbname = "orozdesign_Client3IATools"; // El nombre de tu base de datos

// Crear la conexión.
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar la conexión.
if ($conn->connect_error) {
    header('Content-Type: application/json');
    http_response_code(500);
    die(json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos: ' . $conn->connect_error]));
}

// Establecer el charset a UTF-8.
$conn->set_charset("utf8");

?>
