<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLIENT3 | Generador De Anuncios Publicitarios - Academia De Publicidad</title>
    <?php include 'gtm-header.php'; ?>
   <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { font-family: 'Barlow', sans-serif; }
        .result-card-container { opacity: 0; transform: translateY(20px); animation: slide-in 0.5s ease-out forwards; }
        @keyframes slide-in { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
        .loader { border: 4px solid #f3f3f3; border-top: 4px solid #07162d; border-radius: 50%; width: 24px; height: 24px; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        .ad-part { border-left: 3px solid #e5e7eb; padding-left: 1rem; margin-left: 0.75rem; }
        .ad-part-icon { position: absolute; left: -11px; top: 0; background-color: white; padding: 2px; color: #07162d; }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Barlow', 'sans-serif'], },
                    colors: { 
                        'brand-blue-dark': '#07162d', 
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-5xl">
        <!-- ▼▼▼ LOGO ▼▼▼ -->
        <div class="text-center mb-6">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>
        <!-- ▲▲▲ LOGO ▲▲▲ -->
        <header class="text-center mb-8">
            <h1 class="text-4xl font-black text-brand-blue-dark">GENERADOR DE ANUNCIOS PUBLICITARIOS</h1>
            <p class="text-gray-600 mt-2 text-xl">Crea Textos De Anuncios Que Realmente Venden Para Tus Servicios</p>
        </header>

        <div class="bg-white p-6 md:p-8 rounded-2xl shadow-lg">
            <form id="ad-generator-form" class="space-y-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="business_name" class="block text-lg font-semibold text-brand-blue-dark mb-2">Nombre De Tu Negocio</label>
                        <input type="text" id="business_name" placeholder="Ej: Rod Home Cleaning" class="w-full p-3 border border-gray-300 rounded-md" required>
                    </div>
                    <div>
                        <label for="phone" class="block text-lg font-semibold text-brand-blue-dark mb-2">Teléfono / WhatsApp</label>
                        <input type="text" id="phone" placeholder="Ej: (425) 555-1234" class="w-full p-3 border border-gray-300 rounded-md" required>
                    </div>
                </div>
                <div>
                    <label for="website" class="block text-lg font-semibold text-brand-blue-dark mb-2">C. Página Web o Facebook (Opcional)</label>
                    <input type="text" id="website" placeholder="Ej: https://TuSitioWeb.com" class="w-full p-3 border border-gray-300 rounded-md">
                </div>
                
                <hr class="my-4"/>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="service" class="block text-lg font-semibold text-brand-blue-dark mb-2">Servicio A Promocionar</label>
                        <input type="text" id="service" placeholder="Ej: Deep Cleaning" class="w-full p-3 border border-gray-300 rounded-md" required>
                    </div>
                    <div>
                        <label for="zone" class="block text-lg font-semibold text-brand-blue-dark mb-2">Zona De Servicio</label>
                        <input type="text" id="zone" placeholder="Ej: Seattle WA" class="w-full p-3 border border-gray-300 rounded-md" required>
                    </div>
                </div>
                <div>
                    <label for="problem" class="block text-lg font-semibold text-brand-blue-dark mb-2">Problema Urgente Del Cliente Ideal</label>
                    <textarea id="problem" placeholder="Ej: No Tiene Tiempo Para Limpiar" class="w-full p-3 border border-gray-300 rounded-md" rows="3" required></textarea>
                </div>
                <div>
                    <label for="desire" class="block text-lg font-semibold text-brand-blue-dark mb-2">Deseo Profundo Del Cliente Ideal</label>
                    <textarea id="desire" placeholder="Ej: Menos Estrés" class="w-full p-3 border border-gray-300 rounded-md" rows="3" required></textarea>
                </div>
                
                <button id="generateBtn" type="submit" class="w-full bg-brand-red text-white font-bold py-3 px-4 rounded-lg hover:opacity-90 transition-opacity shadow-lg text-lg flex items-center justify-center">
                    <span id="btn-text">Generar Anuncios Estratégicos</span>
                    <div id="loader" class="loader hidden ml-3"></div>
                </button>
            </form>
        </div>
        
        <div id="result-container" class="mt-8"></div>
    </div>
            <div class="text-center mt-8 mb-8">
        <a href="index.php" class="text-brand-blue-dark text-xl md:text-2xl font-extrabold flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i> REGRESAR AL PORTAL
        </a>
    </div>
  <?php include 'FooterBK.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('ad-generator-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loader = document.getElementById('loader');

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Generando Anuncios Publicitarios...';
        loader.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        
        const formData = {
            business_name: document.getElementById('business_name').value,
            phone: document.getElementById('phone').value,
            website: document.getElementById('website').value,
            service: document.getElementById('service').value,
            zone: document.getElementById('zone').value,
            problem: document.getElementById('problem').value,
            desire: document.getElementById('desire').value
        };

        try {
            // Nota: El archivo se llama 'AnunciosAPI.php' para diferenciarlo de la otra herramienta.
                const response = await fetch('API-Generador-De-Anuncios-Publicitarios.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.error || 'Error en la respuesta del servidor.');
            }

            const data = await response.json();
            displayResults(data.anuncios);

        } catch (error) {
            console.error("Error:", error);
            resultContainer.innerHTML = `<div class="text-center p-4 bg-red-100 text-red-700 rounded-lg"><p><strong>Error:</strong> No se pudieron generar los anuncios. ${error.message}</p></div>`;
        } finally {
            btnText.textContent = 'Generar Anuncios Estratégicos';
            loader.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResults(anuncios) {
        resultContainer.innerHTML = '';
        anuncios.forEach((anuncio, index) => {
            const adCard = createAdCard(anuncio, index);
            resultContainer.appendChild(adCard);
        });

        document.querySelectorAll('.copy-btn').forEach(button => {
            button.addEventListener('click', function() {
                const textToCopy = this.dataset.copytext;
                navigator.clipboard.writeText(textToCopy).then(() => {
                    const originalText = this.innerHTML;
                    this.innerHTML = '<i class="fas fa-check"></i> Copiado';
                    setTimeout(() => { this.innerHTML = originalText; }, 2000);
                });
            });
        });
    }

    function createAdCard(anuncio, index) {
        const container = document.createElement('div');
        container.className = 'result-card-container mb-8';
        container.style.animationDelay = `${index * 150}ms`;

        const es_solucion_html = anuncio.es.solucion.replace(/\n/g, '<br>');
        const en_solucion_html = anuncio.en.solucion.replace(/\n/g, '<br>');
        
        const full_es_text = `${anuncio.es.gancho}\n\n${anuncio.es.solucion}\n\n${anuncio.es.cta}`;
        const full_en_text = `${anuncio.en.gancho}\n\n${anuncio.en.solucion}\n\n${anuncio.en.cta}`;

        container.innerHTML = `
            <h2 class="text-2xl font-bold text-brand-blue-dark">${anuncio.titulo}</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4">
                <div class="bg-white p-6 rounded-lg shadow border-t-4 border-brand-red">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-xl font-semibold text-brand-blue-dark">🇪🇸 Español</h3>
                        <button class="copy-btn bg-brand-yellow text-brand-blue-dark font-bold text-sm py-2 px-3 rounded-md hover:opacity-90" data-copytext="${escape(full_es_text)}"><i class="fas fa-copy"></i> Copiar Texto</button>
                    </div>
                    <div class="space-y-5">
                        <div class="relative ad-part"><span class="ad-part-icon"><i class="fas fa-bullhorn text-brand-red"></i></span><strong class="font-medium text-gray-500">Gancho:</strong><p class="mt-1 text-gray-800">${anuncio.es.gancho}</p></div>
                        <div class="relative ad-part"><span class="ad-part-icon"><i class="fas fa-magic-sparkles text-brand-red"></i></span><strong class="font-medium text-gray-500">Solución:</strong><p class="mt-1 text-gray-800">${es_solucion_html}</p></div>
                        <div class="relative ad-part"><span class="ad-part-icon"><i class="fas fa-paper-plane text-brand-red"></i></span><strong class="font-medium text-gray-500">Llamada a la Acción:</strong><p class="mt-1 text-gray-800">${anuncio.es.cta}</p></div>
                    </div>
                </div>
                <div class="bg-white p-6 rounded-lg shadow border-t-4 border-brand-red">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-xl font-semibold text-brand-blue-dark">🇺🇸 English</h3>
                         <button class="copy-btn bg-brand-yellow text-brand-blue-dark font-bold text-sm py-2 px-3 rounded-md hover:opacity-90" data-copytext="${escape(full_en_text)}"><i class="fas fa-copy"></i> Copy Text</button>
                    </div>
                     <div class="space-y-5">
                        <div class="relative ad-part"><span class="ad-part-icon"><i class="fas fa-bullhorn text-brand-red"></i></span><strong class="font-medium text-gray-500">Hook:</strong><p class="mt-1 text-gray-800">${anuncio.en.gancho}</p></div>
                        <div class="relative ad-part"><span class="ad-part-icon"><i class="fas fa-magic-sparkles text-brand-red"></i></span><strong class="font-medium text-gray-500">Solution:</strong><p class="mt-1 text-gray-800">${en_solucion_html}</p></div>
                        <div class="relative ad-part"><span class="ad-part-icon"><i class="fas fa-paper-plane text-brand-red"></i></span><strong class="font-medium text-gray-500">Call to Action:</strong><p class="mt-1 text-gray-800">${anuncio.en.cta}</p></div>
                    </div>
                </div>
            </div>`;
        return container;
    }
    
    function escape(str) { return str.replace(/"/g, '&quot;').replace(/'/g, '&#39;'); }
});
</script>
</body>
</html>