<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLIENT3 | Asistente De Cliente Ideal - Academia De Publicidad</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { font-family: 'Barlow', sans-serif; }
        #result-container { opacity: 0; transform: scale(0.95); animation: fade-in 0.5s ease-out forwards; }
        @keyframes fade-in { to { opacity: 1; transform: scale(1); } }
        .loader { border: 4px solid #f3f3f3; border-top: 4px solid #07162d; border-radius: 50%; width: 24px; height: 24px; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Barlow', 'sans-serif'], },
                    colors: { 
                        'brand-blue-dark': '#07162d', 
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-2xl">
        
        <div class="text-center mb-6">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>

        <header class="text-center mb-8">
            <h1 class="text-4xl font-black text-brand-blue-dark">GENERADOR DE CLIENTE IDEAL</h1>
            <p class="text-gray-600 mt-2 text-xl">Define Con Claridad A Quién Le Vendes Y Cómo Comunicarte Mejor</p>
        </header>

        <div class="bg-white p-6 md:p-8 rounded-2xl shadow-lg">
            <form id="profile-generator-form" class="space-y-6">
                <div>
                    <label for="service" class="block text-lg font-semibold text-brand-blue-dark mb-2">Tu Servicio Principal Es...</label>
                    <input type="text" id="service" placeholder="Ej: Mantenimiento De Jardines" class="w-full p-3 border border-gray-300 rounded-md" required>
                </div>
                <div>
                    <label for="client_desc" class="block text-lg font-semibold text-brand-blue-dark mb-2">Describe A Tus Clientes Como...</label>
                    <input type="text" id="client_desc" placeholder="Ej: Familias con niños y mascotas" class="w-full p-3 border border-gray-300 rounded-md" required>
                </div>
                
                <button id="generateBtn" type="submit" class="w-full bg-brand-red text-white font-bold py-3 px-4 rounded-lg hover:opacity-90 transition-opacity shadow-lg text-lg flex items-center justify-center">
                    <span id="btn-text">Generar Perfil De Cliente Ideal</span>
                    <div id="loader" class="loader hidden ml-3"></div>
                </button>
            </form>
        </div>
        
        <div id="result-container" class="mt-8"></div>
    </div>
    
        <div class="text-center mt-8 mb-8">
            <a href="index.php" class="text-brand-blue-dark text-xl md:text-2xl font-extrabold flex items-center justify-center">
                <i class="fas fa-arrow-left mr-2"></i> REGRESAR AL PORTAL
            </a>
        </div>
    
    <?php include 'FooterBK.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('profile-generator-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loader = document.getElementById('loader');

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Generando Ideas De Clientes Ideales...';
        loader.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        
        const formData = {
            service: document.getElementById('service').value,
            client_desc: document.getElementById('client_desc').value,
        };

        try {
            const response = await fetch('API-Generador-De-Cliente-Ideal.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.error || 'Error en la respuesta del servidor.');
            }

            const data = await response.json();
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            resultContainer.innerHTML = `<div class="text-center p-4 bg-red-100 text-red-700 rounded-lg"><p><strong>Error:</strong> No se pudo generar el perfil.</p></div>`;
        } finally {
            btnText.textContent = 'Generar Perfil de Cliente';
            loader.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        resultContainer.style.opacity = '0';
        resultContainer.innerHTML = `
            <div class="bg-white p-8 rounded-2xl shadow-lg border-t-8 border-brand-red">
                <h2 class="text-3xl font-bold text-center text-brand-blue-dark">${data.titulo_perfil}</h2>
                <hr class="my-6">
                <div class="space-y-6">
                    <div>
                        <h3 class="font-bold text-xl text-brand-blue-dark"><i class="fas fa-heart-crack mr-2 text-brand-red"></i>El Problema Urgente (Su Dolor Actual)</h3>
                        <p class="text-gray-700 mt-2 pl-8">${data.problema}</p>
                    </div>
                    <div>
                        <h3 class="font-bold text-xl text-brand-blue-dark"><i class="fas fa-star mr-2 text-brand-yellow"></i>El Deseo Profundo (Su Beneficio Principal)</h3>
                        <p class="text-gray-700 mt-2 pl-8">${data.deseo}</p>
                    </div>
                </div>
                <div class="mt-8 bg-gray-100 p-6 rounded-lg">
                     <h3 class="font-bold text-xl text-brand-blue-dark"><i class="fas fa-key mr-2 text-brand-red"></i>Frase De Marketing Para Conectar</h3>
                     <p class="text-gray-700 mt-2 pl-8 font-medium">"${data.frase_marketing}"</p>
                </div>
                 <div class="mt-8">
                     <h3 class="font-bold text-xl text-brand-blue-dark"><i class="fas fa-lightbulb mr-2 text-brand-yellow"></i>Sugerencias Para Anuncios</h3>
                     <ul class="list-disc list-inside text-gray-700 mt-2 pl-8 space-y-1">
                         ${data.sugerencias.map(s => `<li>${s}</li>`).join('')}
                     </ul>
                 </div>

                 <div class="mt-8 border-t pt-6">
                     <h3 class="font-bold text-xl text-brand-blue-dark"><i class="fas fa-paste mr-2 text-brand-red"></i>Resumen Para Copiar y Guardar</h3>
                     <div class="relative mt-2">
                         <textarea readonly id="summary-text" class="w-full h-48 p-3 bg-gray-100 text-gray-800 rounded-md border-gray-300 resize-none leading-relaxed">${data.resumen_copiar}</textarea>
                         <button class="copy-btn absolute top-3 right-3 bg-brand-red text-white font-bold text-sm py-1 px-3 rounded-md hover:opacity-90" data-copy-target="summary-text">
                             <i class="fas fa-copy"></i> Copiar
                         </button>
                     </div>
                 </div>
                 </div>
        `;
        
        resultContainer.querySelector('.copy-btn').addEventListener('click', function() {
            const textToCopy = document.getElementById(this.dataset.copyTarget).value;
            navigator.clipboard.writeText(textToCopy).then(() => {
                const originalText = this.innerHTML;
                this.innerHTML = '<i class="fas fa-check"></i> Copiado';
                setTimeout(() => { this.innerHTML = originalText; }, 2000);
            });
        });

        setTimeout(() => { resultContainer.style.opacity = '1'; }, 100);
    }
});
</script>
</body>
</html>