<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sobre Néstor Orozco - Estratega Digital - CLIENT3</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { 
            font-family: 'Barlow', sans-serif; 
        }
        .check-icon {
            color: #9e1428; /* brand-red */
        }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Barlow', 'sans-serif'], },
                    colors: { 
                        'brand-blue-dark': '#07162d', 
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-4xl flex flex-col min-h-screen">
        
        <div class="text-center mb-6">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>

        <main class="flex-grow">
            <div class="w-full">
                <header class="text-center mb-12">
                    <h1 class="text-5xl font-black text-brand-blue-dark">CONOCE A TU ESTRATEGA</h1>
                    <p class="text-gray-600 mt-2 text-xl">Experiencia Y Resultados Comprobados</p>
                </header>

                <div class="bg-white p-6 md:p-10 rounded-2xl shadow-lg max-w-4xl mx-auto space-y-12">
            
                    <!-- Section: Sobre Mí -->
                    <section class="flex flex-col md:flex-row items-center gap-8 text-center md:text-left">
                        <img src="NestorOrozco.jpg" alt="Foto de Néstor Orozco" class="rounded-lg shadow-xl w-48 h-48 md:w-56 md:h-56 object-cover flex-shrink-0">
                        <div>
                            <h2 class="text-3xl font-bold text-brand-blue-dark mb-4">Soy Nestor Orozco Revolorio</h2>
                            <p class="text-gray-700 text-lg">
                                Emprendedor, esposo y padre de cuatro maravillosos hijos. Con más de 16 años de experiencia ayudando a negocios como el tuyo a alcanzar resultados medibles. <br />A lo largo de mi carrera, he tenido la oportunidad de aprender y certificarme con líderes de renombre, lo que me permite compartir estrategias efectivas contigo.
                            </p>
                        </div>
                    </section>
        
                    <!-- Section: Certificaciones -->
                    <section>
                        <h3 class="text-2xl font-bold text-brand-blue-dark text-center border-b-2 border-brand-red pb-2 mb-6">Certificaciones Profesionales</h3>
                        <ul class="space-y-4 text-lg">
                            <li class="flex items-center p-4 bg-brand-blue-dark text-white rounded-lg shadow-lg"><i class="fas fa-check-circle check-icon text-2xl mr-4 flex-shrink-0"></i><span><b class="text-white">Growth Marketing & Marketing Digital</b><br><small class="text-gray-300">Avalado por American Business College, Miami, FL</small></span></li>
                            <li class="flex items-center p-4 bg-brand-blue-dark text-white rounded-lg shadow-lg"><i class="fas fa-check-circle check-icon text-2xl mr-4 flex-shrink-0"></i><span><b class="text-white">Artificial Intelligence & Growth Marketing</b><br><small class="text-gray-300">Avalado por American Business College, Miami, FL</small></span></li>
                            <li class="flex items-center p-4 bg-brand-blue-dark text-white rounded-lg shadow-lg"><i class="fas fa-check-circle check-icon text-2xl mr-4 flex-shrink-0"></i><span><b class="text-white">Trafficker Digital Junior</b><br><small class="text-gray-300">Avalado por Florida Global University, Miami, FL</small></span></li>
                        </ul>
                    </section>
        
                    <!-- Section: Mentores -->
                    <section>
                        <h3 class="text-2xl font-bold text-brand-blue-dark text-center border-b-2 border-brand-red pb-2 mb-6">Formado Por Grandes Líderes De La Industria</h3>
                        <div class="text-center mb-8">
                             <img src="Mentores.png" alt="Mentores de Néstor Orozco" class="mx-auto rounded-lg shadow-xl w-full max-w-2xl">
                        </div>
                        <p class="text-gray-700 text-lg text-center mb-6">
                           Tengo el privilegio de haberme formado (y seguirme formando) con mentores destacados que han inspirado y aportado a mi metodología:
                        </p>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-gray-800 text-left">
                            <div class="bg-gray-50 p-4 rounded-lg shadow-sm"><b>Dr. Vilma Núñez:</b> Una de las mayores referentes del marketing digital en habla hispana, Doctora en Publicidad y CEO de la agencia Convierte Más.</div>
                            <div class="bg-gray-50 p-4 rounded-lg shadow-sm"><b>Ricardo Leyva:</b> Reconocido experto en marketing y fundador de Sístole, famoso por su participación como inversionista en Shark Tank Colombia.</div>
                            <div class="bg-gray-50 p-4 rounded-lg shadow-sm"><b>Brian Tracy:</b> Autor de más de 80 best-sellers sobre liderazgo y desarrollo personal, traducidos a decenas de idiomas, como el famoso "Eat That Frog!".</div>
                            <div class="bg-gray-50 p-4 rounded-lg shadow-sm"><b>Philip Kotler:</b> Considerado una leyenda y el "Padre del Marketing Moderno", autor de "Marketing Management", el libro de texto más utilizado en la materia a nivel mundial.</div>
                        </div>
                    </section>
        
                     <!-- Section: Closing Statement -->
                    <section class="text-center p-6 bg-brand-blue-dark rounded-lg shadow-inner">
                        <p class="text-white font-semibold text-xl italic">
                            "Estoy convencido de que las estrategias que he aprendido y perfeccionado pueden marcar la diferencia en tus resultados."
                        </p>
                    </section>
        
                </div>

<div class="text-center mt-8 mb-8">
        <a href="index.php" class="text-brand-blue-dark text-xl md:text-2xl font-extrabold flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i> REGRESAR AL PORTAL
        </a>
    </div>
               
            </div>
        </main>
        

    <?php include 'FooterBK.php'; ?>
    </div>
</body>
</html>