<?php
session_start(); 

$message = ''; 

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include 'ConectAPI.php'; 

    if ($conn->connect_error) {
        $message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong class="font-bold">¡Error de Conexión!</strong><span class="block sm:inline"> No se pudo conectar a la base de datos.</span></div>';
    } else {
        $nombre = trim($_POST['nombre']);
        $email = trim($_POST['email']);
        $password = $_POST['password'];
        $producto_comprado = "Acceso Estandar";
        $fecha_registro = date('Y-m-d H:i:s');
        $fecha_expiracion = date('Y-m-d', strtotime('+1 month'));

        if (empty($nombre) || empty($email) || empty($password)) {
            $message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong class="font-bold">¡Error!</strong><span class="block sm:inline"> Por favor, llena todos los campos obligatorios.</span></div>';
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong class="font-bold">¡Error!</strong><span class="block sm:inline"> El formato del correo electrónico no es válido.</span></div>';
        } else {
            $stmt_check = $conn->prepare("SELECT id FROM estudiantes WHERE email = ?");
            $stmt_check->bind_param("s", $email);
            $stmt_check->execute();
            $stmt_check->store_result();

            if ($stmt_check->num_rows > 0) {
                $message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong class="font-bold">¡Error!</strong><span class="block sm:inline"> Este correo electrónico ya está registrado.</span></div>';
            } else {
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                
                $stmt = $conn->prepare("INSERT INTO estudiantes (nombre, email, password, producto_comprado, fecha_registro, fecha_expiracion) VALUES (?, ?, ?, ?, ?, ?)");

                if ($stmt === false) {
                    $message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong class="font-bold">¡Error del Sistema!</strong><span class="block sm:inline"> No se pudo procesar el registro. Por favor, contacta a soporte.</span></div>';
                } else {
                    $stmt->bind_param("ssssss", $nombre, $email, $hashed_password, $producto_comprado, $fecha_registro, $fecha_expiracion);

                    if ($stmt->execute()) {
                        header('Location: Gracias-Registro-Exitoso.php');
                        exit;
                    } else {
                        $message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong class="font-bold">¡Error!</strong><span class="block sm:inline"> Hubo un problema al crear tu cuenta. Inténtalo de nuevo.</span></div>';
                    }
                    $stmt->close();
                }
            }
            $stmt_check->close();
            $conn->close();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro de Estudiantes - Academia De Publicidad</title>
       <?php include 'gtm-header.php'; ?>
       <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        :root {
            --color-primary: #07162d;   /* Azul Oscuro */
            --color-secondary: #9e1428; /* Rojo */
            --color-highlight: #ffc857; /* Amarillo */
            --color-white: #ffffff;
            --color-text: #3d3d3d;
            --color-light-text: #e0e0e0;
        }
        body {
            font-family: 'Barlow', sans-serif;
            background-color: var(--color-primary);
            margin: 0;
            padding: 2rem 1rem;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
    </style>
</head>
<body>
    <div class="container mx-auto p-4 flex min-h-screen items-center justify-center">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-0 max-w-5xl rounded-2xl shadow-2xl overflow-hidden">
            <!-- Columna de la imagen (visible en pantallas medianas y grandes) -->
            <div class="hidden md:block">
                 <!-- ***** INICIO DEL CAMBIO ***** -->
                 <!-- Se cambió 'object-cover' por 'object-contain' para que la imagen no se corte -->
                 <img src="Portada.jpg" alt="Portada Recurso" class="w-full h-full object-contain">
                 <!-- ***** FIN DEL CAMBIO ***** -->
            </div>
            
            <!-- Contenedor del formulario -->
            <div class="bg-white p-8 md:p-12 flex flex-col justify-center">
                <header class="text-center mb-6">
                    <img src="LogoPlataformaNegro.png" alt="Logo Plataforma" class="mx-auto h-20 w-auto mb-4">
                    <h1 class="text-3xl font-black">
                        <span class="text-[var(--color-primary)]">CREA TU</span> <span class="text-[var(--color-secondary)]">CUENTA</span>
                    </h1>
                    <p class="text-gray-600 mt-2">Completa Tus Datos De Acceso Para Empezar.</p>
                </header>
                
                <?php echo $message; // Muestra mensajes de estado (éxito/error) ?>
                
                <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="POST" class="space-y-6">
                    <div>
                        <label for="nombre" class="block text-left text-gray-700 font-semibold mb-1 sr-only">Nombre Completo:</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                                <i class="fas fa-user text-gray-400"></i>
                            </span>
                            <input type="text" id="nombre" name="nombre" 
                                   class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-[var(--color-highlight)] focus:border-[var(--color-highlight)]" 
                                   placeholder="Tu Nombre Completo" required>
                        </div>
                    </div>
                    <div>
                        <label for="email" class="block text-left text-gray-700 font-semibold mb-1 sr-only">Correo Electrónico:</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                                <i class="fas fa-envelope text-gray-400"></i>
                            </span>
                            <input type="email" id="email" name="email" 
                                   class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-[var(--color-highlight)] focus:border-[var(--color-highlight)]" 
                                   placeholder="Tu Correo Electrónico" required>
                        </div>
                    </div>
                    <div>
                        <label for="password" class="block text-left text-gray-700 font-semibold mb-1 sr-only">Contraseña:</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                                <i class="fas fa-lock text-gray-400"></i>
                            </span>
                            <input type="password" id="password" name="password" 
                                   class="w-full pl-10 pr-10 py-3 border border-gray-300 rounded-lg focus:ring-[var(--color-highlight)] focus:border-[var(--color-highlight)]" 
                                   placeholder="Crea una contraseña segura" required>
                            <span class="absolute inset-y-0 right-0 flex items-center pr-3 cursor-pointer" id="togglePassword">
                                <i class="fas fa-eye text-gray-400" id="eyeIcon"></i>
                            </span>
                        </div>
                    </div>
                    <button type="submit" class="w-full bg-[var(--color-primary)] text-white font-bold py-3 px-8 rounded-lg hover:bg-opacity-90 transition-opacity shadow-lg text-lg">
                        REGISTRARME
                    </button>
                </form>
                
                <div class="text-center mt-6">
                    <p class="text-gray-600 text-sm">¿Ya tienes cuenta? <a href="index.php" class="text-[var(--color-secondary)] hover:underline font-semibold">Inicia Sesión aquí</a></p>
                </div>

                <!-- Pie de Página -->
                <div class="mt-8">
                    <?php include 'FooterBK.php'; ?>
                </div>
            </div>
        </div>
    </div>

    <script>
        // JavaScript para alternar la visibilidad de la contraseña
        const togglePassword = document.querySelector('#togglePassword');
        if (togglePassword) {
            const passwordInput = document.querySelector('#password');
            const eyeIcon = document.querySelector('#eyeIcon');
            togglePassword.addEventListener('click', function () {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                eyeIcon.classList.toggle('fa-eye');
                eyeIcon.classList.toggle('fa-eye-slash');
            });
        }
    </script>
</body>
</html>
