<?php
session_start();
header('Content-Type: application/json');

// --- VERIFICACIÓN DE SEGURIDAD ---
if (!isset($_SESSION['admin_loggedin']) || $_SESSION['admin_loggedin'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Acceso no autorizado.']);
    exit;
}

// Incluir la conexión a la base de datos.
include '../ConectAPI.php';

// Recoger los datos enviados desde el formulario.
$id = $_POST['id'] ?? null;
$nombre = $_POST['nombre'] ?? '';
$email = $_POST['email'] ?? '';
$password_input = $_POST['password'] ?? '';
$fecha_expiracion = $_POST['fecha_expiracion'] ?? '';
$fecha_registro = date('Y-m-d');

// Validación básica de los datos.
if (empty($nombre) || empty($email) || empty($fecha_expiracion)) {
    echo json_encode(['success' => false, 'message' => 'Los campos Nombre, Email y Fecha de Expiración son obligatorios.']);
    exit;
}

// Si es un nuevo estudiante (no hay ID).
if (empty($id)) {
    if (empty($password_input)) {
        echo json_encode(['success' => false, 'message' => 'La contraseña es obligatoria para los nuevos estudiantes.']);
        exit;
    }
    
    $password_hash = password_hash($password_input, PASSWORD_DEFAULT);

    // Se eliminó 'producto_comprado' de la consulta
    $sql = "INSERT INTO estudiantes (nombre, email, password, fecha_registro, fecha_expiracion) VALUES (?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssss", $nombre, $email, $password_hash, $fecha_registro, $fecha_expiracion);

} else { // Si es un estudiante existente (se está editando).
    
    if (!empty($password_input)) {
        $password_hash = password_hash($password_input, PASSWORD_DEFAULT);
        // Se eliminó 'producto_comprado' de la consulta
        $sql = "UPDATE estudiantes SET nombre = ?, email = ?, password = ?, fecha_expiracion = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssi", $nombre, $email, $password_hash, $fecha_expiracion, $id);
    } else {
        // Se eliminó 'producto_comprado' de la consulta
        $sql = "UPDATE estudiantes SET nombre = ?, email = ?, fecha_expiracion = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssi", $nombre, $email, $fecha_expiracion, $id);
    }
}

// Ejecutar la consulta y devolver una respuesta.
if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Estudiante guardado con éxito.']);
} else {
    if ($conn->errno == 1062) {
        echo json_encode(['success' => false, 'message' => 'Error: El correo electrónico ya existe en la base de datos.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al guardar en la base de datos: ' . $stmt->error]);
    }
}

$stmt->close();
$conn->close();
?>