<?php
session_start();
header('Content-Type: application/json');

// VERIFICACIÓN DE SEGURIDAD
if (!isset($_SESSION['admin_loggedin']) || $_SESSION['admin_loggedin'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Acceso no autorizado.']);
    exit;
}

include '../ConectAPI.php';
// --- CORRECCIÓN: Se verifica de forma segura si el ID del admin existe en la sesión ---
$admin_id = $_SESSION['admin_id'] ?? null; 

if (!$admin_id) {
    echo json_encode(['success' => false, 'message' => 'Error de sesión: ID de administrador no encontrado. Por favor, inicie sesión de nuevo.']);
    exit;
}

$response = ['success' => false, 'message' => 'Petición inválida.'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $conn->begin_transaction();
    try {
        // --- Actualizar Perfil de Administrador ---
        $admin_nombre = $_POST['admin_nombre'] ?? '';
        $admin_email = $_POST['admin_email'] ?? '';
        $admin_password = $_POST['admin_password'] ?? '';

        $sql_admin_parts = [];
        $params_admin = [];
        $types_admin = "";

        if (!empty($admin_nombre)) {
            $sql_admin_parts[] = "nombre = ?";
            $params_admin[] = $admin_nombre;
            $types_admin .= "s";
            $_SESSION['admin_name'] = $admin_nombre; // Actualizar sesión
        }
        if (!empty($admin_email)) {
            $sql_admin_parts[] = "email = ?";
            $params_admin[] = $admin_email;
            $types_admin .= "s";
        }
        if (!empty($admin_password)) {
            $sql_admin_parts[] = "password = ?";
            $params_admin[] = password_hash($admin_password, PASSWORD_DEFAULT);
            $types_admin .= "s";
        }

        // --- Manejo de Subida de Foto de Perfil ---
        if (isset($_FILES['admin_foto']) && $_FILES['admin_foto']['error'] == 0) {
            $upload_dir = '../uploads/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0755, true);
            }
            $file_ext = pathinfo($_FILES['admin_foto']['name'], PATHINFO_EXTENSION);
            $new_filename = "admin_photo_" . $admin_id . "." . $file_ext;
            $upload_file = $upload_dir . $new_filename;

            if (move_uploaded_file($_FILES['admin_foto']['tmp_name'], $upload_file)) {
                $sql_admin_parts[] = "foto_perfil = ?";
                $params_admin[] = "uploads/" . $new_filename; // Guardar ruta relativa
                $types_admin .= "s";
                $_SESSION['admin_photo'] = "uploads/" . $new_filename; // Actualizar sesión
            }
        }

        if (!empty($sql_admin_parts)) {
            $sql_admin = "UPDATE admins SET " . implode(", ", $sql_admin_parts) . " WHERE id = ?";
            $params_admin[] = $admin_id;
            $types_admin .= "i";
            $stmt_admin = $conn->prepare($sql_admin);
            $stmt_admin->bind_param($types_admin, ...$params_admin);
            $stmt_admin->execute();
            $stmt_admin->close();
        }

        // --- Actualizar Configuración (Precio y Colores) ---
        $settings = [
            'precio_producto' => $_POST['precio_producto'] ?? null,
            'color_primario' => $_POST['color_primario'] ?? null,
            'color_secundario' => $_POST['color_secundario'] ?? null,
            'color_resaltado' => $_POST['color_resaltado'] ?? null,
            'color_fondo' => $_POST['color_fondo'] ?? null,
        ];

        $sql_settings = "INSERT INTO configuracion (clave, valor) VALUES (?, ?) ON DUPLICATE KEY UPDATE valor = VALUES(valor)";
        $stmt_settings = $conn->prepare($sql_settings);

        foreach ($settings as $clave => $valor) {
            if ($valor !== null) {
                $stmt_settings->bind_param('ss', $clave, $valor);
                $stmt_settings->execute();
            }
        }
        $stmt_settings->close();

        $conn->commit();
        $response = ['success' => true, 'message' => 'Configuración guardada con éxito.'];

    } catch (Exception $e) {
        $conn->rollback();
        $response = ['success' => false, 'message' => 'Error al guardar la configuración: ' . $e->getMessage()];
    }
}

$conn->close();
echo json_encode($response);
?>
