<?php
// Habilita el reporte de errores para depuración (opcional, remueve en producción)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Establece la cabecera para indicar que la respuesta será JSON
header('Content-Type: application/json');

// Verifica que la solicitud sea de tipo POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // --- CONFIGURACIÓN ---
    $recipient_email = "orozdesign@gmail.com"; // <-- ¡MUY IMPORTANTE! Cambia esto por tu email.
    $subject_prefix = "[Nuevo Envio De Formulario]";
    // --------------------

    // Recoger y limpiar los datos del formulario
    // strip_tags: Elimina etiquetas HTML y PHP del string
    // trim: Elimina espacios en blanco (u otros caracteres) del inicio y final del string
    // filter_var: Filtra una variable con un filtro específico (ej. validar email)
    $nombre = isset($_POST['nombre']) ? strip_tags(trim($_POST['nombre'])) : 'No proporcionado';
    $email = isset($_POST['email']) ? filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL) : 'No proporcionado';
    $telefono = isset($_POST['telefono']) ? strip_tags(trim($_POST['telefono'])) : 'No proporcionado';
    $tipo_negocio = isset($_POST['tipo_negocio']) ? strip_tags(trim($_POST['tipo_negocio'])) : 'No proporcionado';
    $ubicacion = isset($_POST['ubicacion']) ? strip_tags(trim($_POST['ubicacion'])) : 'No proporcionado';
    $calificacion = isset($_POST['calificacion']) ? strip_tags(trim($_POST['calificacion'])) : 'No proporcionado';
    $comentario = isset($_POST['comentario']) ? trim($_POST['comentario']) : 'No proporcionado'; // No strip_tags para comentarios, para permitir saltos de línea
    $ideas_mejora = isset($_POST['ideas_mejora']) ? trim($_POST['ideas_mejora']) : 'No proporcionado'; // No strip_tags para ideas de mejora

    // Validación básica (el email es el más crucial)
    // Si el nombre está vacío O el email no es válido, se considera un error
    if (empty($nombre) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400); // Bad Request HTTP status code
        echo json_encode(['status' => 'error', 'message' => 'Hubo un error con los datos enviados. Por favor, verifica el nombre y el email.']);
        exit; // Detiene la ejecución del script
    }

    // Construir el cuerpo del email de forma clara y legible
    $email_content = "Has Recibido Un Envio Del Formulario:\n\n";
    $email_content .= "========================================\n";
    $email_content .= "INFORMACIÓN DE CONTACTO\n";
    $email_content .= "========================================\n";
    $email_content .= "Nombre: $nombre\n";
    $email_content .= "Email: $email\n";
    $email_content .= "Teléfono: $telefono\n\n";

    $email_content .= "========================================\n";
    $email_content .= "DETALLES DEL NEGOCIO\n";
    $email_content .= "========================================\n";
    $email_content .= "Tipo de Negocio: $tipo_negocio\n";
    $email_content .= "Estado o País: $ubicacion\n\n";

    $email_content .= "========================================\n";
    $email_content .= "FEEDBACK\n";
    $email_content .= "========================================\n";
    $email_content .= "Calificación del Recurso: $calificacion\n\n";
    $email_content .= "Comentarios:\n$comentario\n\n";
    $email_content .= "Ideas de Mejora:\n$ideas_mejora\n";
    $email_content .= "========================================\n";

    // Construir las cabeceras del email
    // Esto asegura que cuando respondas, le respondas al usuario
    $email_headers = "From: $nombre <$email>\r\n";
    $email_headers .= "Reply-To: $email\r\n";
    $email_headers .= "Content-Type: text/plain; charset=UTF-8\r\n"; // Asegura que el contenido sea texto plano y UTF-8
    $email_headers .= "X-Mailer: PHP/" . phpversion(); // Información del software que envía el correo

    // Enviar el email
    // La función mail() devuelve true en caso de éxito, false en caso de error
    if (mail($recipient_email, "$subject_prefix $tipo_negocio - $nombre", $email_content, $email_headers)) {
        http_response_code(200); // OK HTTP status code
        echo json_encode(['status' => 'success', 'message' => 'Mensaje enviado exitosamente.']);
    } else {
        http_response_code(500); // Internal Server Error HTTP status code
        echo json_encode(['status' => 'error', 'message' => 'Oops! Algo salió mal y no pudimos enviar tu mensaje.']);
    }

} else {
    // Si la solicitud no es de tipo POST, prohíbe el acceso
    http_response_code(403); // Forbidden HTTP status code
    echo json_encode(['status' => 'error', 'message' => 'Hubo un problema con tu envío, por favor intenta de nuevo desde el formulario.']);
}
?>
