<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Simulación de Chat WhatsApp</title>
    <!-- Carga de Tailwind CSS para utilidades generales -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        /* Estilos generales del cuerpo */
        body {
            font-family: 'Inter', sans-serif;
            background-color: #e0e0e0; /* Fondo gris claro */
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            overflow: hidden; /* Evita el scroll del body */
        }

        /* Contenedor principal del chat, ahora a pantalla completa */
        .chat-container {
            background-color: #f0f0f0; /* Fondo del chat */
            width: 100vw; /* Ocupa el 100% del ancho del viewport */
            height: 100vh; /* Ocupa el 100% de la altura del viewport */
            display: flex;
            flex-direction: column;
            border-radius: 0; /* Elimina bordes redondeados para pantalla completa */
            box-shadow: none; /* Elimina sombra para pantalla completa */
            overflow: hidden; /* Asegura que el contenido no se desborde */
            position: relative; /* Para posicionar elementos internos */
        }

        /* Estilo del encabezado del chat */
        .header {
            background-color: #075e54; /* Color verde de WhatsApp */
            color: white;
            padding: 1rem;
            display: flex;
            align-items: center;
            gap: 0.75rem; /* Espacio entre elementos */
            border-top-left-radius: 0; /* Elimina bordes redondeados */
            border-top-right-radius: 0; /* Elimina bordes redondeados */
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            z-index: 10; /* Asegura que esté por encima del chatbox */
        }

        .header img {
            width: 3rem; /* Tamaño de la imagen de perfil */
            height: 3rem;
            border-radius: 50%; /* Circular */
            object-fit: cover;
            border: 2px solid white; /* Borde blanco alrededor de la imagen */
        }

        .header strong {
            font-size: 1.125rem; /* Texto más grande para el nombre */
            font-weight: 600;
        }

        .status {
            font-size: 0.875rem; /* Texto más pequeño para el estado */
            color: rgba(255, 255, 255, 0.8);
        }

        /* Contenedor de los mensajes de chat */
        #chatbox {
            flex-grow: 1; /* Ocupa todo el espacio disponible */
            padding: 1rem;
            overflow-y: auto; /* Permite el scroll de los mensajes */
            /* Fondo de chat simulado, puedes reemplazarlo con una imagen real de fondo de WhatsApp */
            background-image: url('https://placehold.co/400x800/E0E0E0/FFFFFF?text=Fondo+Chat');
            background-size: cover;
            background-position: center;
            display: flex;
            flex-direction: column;
            gap: 0.5rem; /* Espacio entre burbujas de chat */
        }

        /* Estilo de las burbujas de chat */
        .chat {
            background-color: #DCF8C6; /* Verde claro para mensajes entrantes */
            padding: 0.6rem 0.8rem;
            border-radius: 0.5rem; /* Bordes redondeados */
            max-width: 85%; /* Ancho máximo de la burbuja */
            align-self: flex-start; /* Alinea los mensajes a la izquierda */
            word-wrap: break-word; /* Rompe palabras largas */
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.08); /* Sombra sutil */
            font-size: 0.95rem;
            line-height: 1.3;
        }

        /* Estilo para el indicador de "escribiendo..." */
        #typing {
            background-color: #fff; /* Fondo blanco */
            padding: 0.6rem 0.8rem;
            border-radius: 0.5rem;
            max-width: fit-content;
            align-self: flex-start; /* Alinea a la izquierda como un mensaje normal */
            margin-top: 0.5rem;
            margin-bottom: 0.5rem;
            color: #666;
            font-style: italic;
            font-size: 0.85rem; /* Un poco más pequeño que el texto normal */
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.08);
            display: none; /* Oculto por defecto */
        }

        /* Estilo para imágenes dentro de las burbujas */
        .chat img {
            border-radius: 0.5rem;
            max-width: 100%; /* Asegura que la imagen no se desborde */
            height: auto;
            margin-top: 0.5rem; /* Espacio superior para la imagen */
            cursor: pointer; /* Indica que es clicable */
        }

        /* Contenedor para los botones, ahora dentro de una burbuja de chat si es necesario */
        .button-box {
            display: flex;
            flex-direction: column; /* Botones apilados */
            gap: 0.75rem; /* Espacio entre botones */
            /* Estos estilos se manejan ahora por la burbuja de chat que los contiene */
            padding: 0;
            background-color: transparent;
            border-bottom-left-radius: 0;
            border-bottom-right-radius: 0;
        }

        .button {
            padding: 0.75rem 1rem;
            border-radius: 0.75rem; /* Bordes más redondeados */
            font-weight: 600;
            font-size: 1rem;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.2s ease;
            text-align: center;
            border: none;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .button:hover {
            transform: translateY(-2px); /* Efecto hover */
        }

        .whatsapp {
            background-color: #25D366; /* Verde WhatsApp */
            color: white;
        }

        .whatsapp:hover {
            background-color: #1DA851;
        }

        .facebook {
            background-color: #1877F2; /* Azul Facebook */
            color: white;
        }

        .facebook:hover {
            background-color: #145CB3;
        }

        /* Estilo para los elementos de audio, para que parezcan una burbuja de chat */
        .audio-message {
            background-color: #DCF8C6; /* Mismo verde que las burbujas de chat */
            padding: 0.6rem 0.8rem;
            border-radius: 0.5rem;
            max-width: 85%;
            align-self: flex-start;
            word-wrap: break-word;
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.08);
            font-size: 0.95rem;
            line-height: 1.3;
            display: flex; /* Para alinear los controles de audio */
            align-items: center;
            gap: 0.5rem;
        }

        /* Estilo para el audio (simulado) */
        .audio-placeholder {
            background-color: #DCF8C6;
            padding: 0.6rem 0.8rem;
            border-radius: 0.5rem;
            max-width: fit-content; /* Se ajusta al contenido */
            align-self: flex-start;
            word-wrap: break-word;
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.08);
            font-size: 0.95rem;
            line-height: 1.3;
            color: #333;
            font-style: italic;
        }

        /* Media queries para asegurar que siempre sea pantalla completa */
        @media (min-width: 601px) {
            .chat-container {
                max-width: 100vw;
                height: 100vh;
            }
        }
    </style>
</head>
<body>
    <div class="chat-container">
        <!-- Encabezado del chat -->
        <div class="header">
            <img src="https://placehold.co/50x50/075E54/FFFFFF?text=N" alt="Nestor" onerror="this.onerror=null;this.src='https://placehold.co/50x50/075E54/FFFFFF?text=N';" />
            <div>
                <strong id="header-title">Nestor | OrozDesign</strong><br /> <!-- Añadido ID para actualización dinámica -->
                <span class="status">en línea</span>
            </div>
        </div>

        <!-- Contenedor de los mensajes de chat -->
        <div id="chatbox"></div>
        <!-- Indicador de "Escribiendo..." -->
        <div id="typing" class="typing" style="display: none;">Escribiendo...</div>
    </div>

    <!-- JavaScript para la lógica del chat -->
    <script>
        console.log("Script de simulación de chat cargado y ejecutándose.");

        const chatbox = document.getElementById("chatbox");
        const typing = document.getElementById("typing");
        const headerTitle = document.getElementById("header-title"); // Referencia al título del encabezado

        // Función para obtener parámetros de la URL
        function getUrlParameter(name) {
            name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
            const regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
            const results = regex.exec(location.search);
            return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
        }

        // Obtener la palabra clave de la URL (ej. ?keyword=diseño+grafico)
        const userSearchKeyword = getUrlParameter('keyword') || getUrlParameter('q') || ''; // Puedes usar 'q' o 'keyword'
        let dynamicHeaderSuffix = '';

        if (userSearchKeyword) {
            // Capitalizar la primera letra de cada palabra para el encabezado
            dynamicHeaderSuffix = userSearchKeyword.split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1)).join(' ');
            headerTitle.textContent = `Nestor | ${dynamicHeaderSuffix}`;
        }

        // Definición de la conversación principal
        // Se usa el placeholder {keyword} que será reemplazado dinámicamente
        const conversationSteps = [
            { type: 'message', content: `¡Hola! 👋 ¿Sabías que la primera impresión de tu negocio es crucial? Especialmente cuando buscan sobre ${userSearchKeyword || 'tu área de interés'}.`, delay: 2000 },
            { type: 'message', content: "Muchos clientes deciden confiar en ti solo por cómo se ve tu marca.", delay: 3000 },
            { type: 'message', content: "Por eso, en OrozDesign, creamos logotipos profesionales que realmente conectan con tu público. ✨", delay: 3500 },
            { type: 'message', content: "Imagina tener un logo que transmita confianza y profesionalismo desde el primer vistazo.", delay: 3000 },
            { type: 'message', content: "Con nuestro paquete, obtienes:", delay: 2000 },
            { type: 'message', content: "✅ Diseño de logotipo impactante", delay: 1500 },
            { type: 'message', content: "✅ 1,000 tarjetas de presentación listas para imprimir", delay: 1500 },
            { type: 'message', content: "✅ Archivos editables para usar donde quieras", delay: 1500 },
            { type: 'message', content: "Mira algunos ejemplos de logos que hemos diseñado para negocios como el tuyo:", delay: 3000 },
            { type: 'image', src: 'https://placehold.co/300x200/FF0000/FFFFFF?text=Logo+Ejemplo+1', alt: '', delay: 2500 },
            { type: 'image', src: 'https://placehold.co/300x200/00FF00/FFFFFF?text=Logo+Ejemplo+2', alt: '', delay: 2500 },
            { type: 'image', src: 'https://placehold.co/300x200/0000FF/FFFFFF?text=Logo+Ejemplo+3', alt: '', delay: 2500 },
            { type: 'message', content: "¿Te gustaría saber cómo un logo así puede transformar tu negocio y cuál es la inversión?", delay: 3000 },
            {
                type: 'clickable-image', // Nuevo tipo para la imagen clicable
                src: 'https://placehold.co/300x200/FFA500/FFFFFF?text=Descubre+el+Precio',
                alt: '',
                delay: 2000,
                action: 'triggerPriceReveal' // Llama a la función global para revelar el precio
            }
        ];

        // Secuencia para revelar el precio
        const priceRevealSteps = [
            { type: 'message', content: "<s>Precio regular: $350 USD</s>", isHTML: true, delay: 2000 },
            { type: 'message', content: "<strong>🔥 HOY: $250 USD – ¡Sin mensualidades!</strong>", isHTML: true, delay: 2500 },
            { type: 'audio-simulated', delay: 3000, audioSrc: "https://www.w3schools.com/html/horse.mp3", audioDuration: 10000 }, // Simulación de audio
            { type: 'message', content: "¿Listo para darle a tu negocio la imagen que se merece?", delay: 3000 },
            {
                type: 'buttons',
                delay: 2000,
                buttons: [
                    { className: 'whatsapp', html: '✅ Sí, quiero mi logotipo profesional', action: () => window.location.href='https://wa.me/14252434579?text=Hola Nestor, quiero un logotipo profesional para mi negocio' },
                    { className: 'facebook', html: '❌ No, prefiero seguir en Facebook', action: 'triggerLastChanceSequence' }
                ]
            }
        ];

        // Secuencia de "última oportunidad"
        const lastChanceSteps = [
            { type: 'message', content: "😅 ¡Espera! No todos los días tienes esta oportunidad...", delay: 2000 },
            { type: 'message', content: `🤔 Tu negocio merece destacar en ${userSearchKeyword || 'tu sector'}. ¿Estás seguro de que quieres perder esto?`, delay: 2500 },
            { type: 'message', content: "🎯 ¡Haz la diferencia hoy mismo y asegura tu oferta!", delay: 2000 },
            { type: 'image', src: 'https://placehold.co/300x200/FF0000/FFFFFF?text=Ultima+Oportunidad', alt: '', delay: 2500 },
            { type: 'message', content: "<strong>😥 ¿Estás seguro que quieres salir?</strong>", isHTML: true, delay: 2000 },
            { type: 'message', content: "Esta oferta especial fue creada solo para ti.<br> Si sales ahora, podrías perderla para siempre.", isHTML: true, delay: 2500 },
            {
                type: 'buttons',
                delay: 2000,
                buttons: [
                    { className: 'whatsapp', html: '💬 Hablar con una persona', action: () => window.location.href='https://wa.me/14252434579?text=Hola, quiero hablar con alguien sobre la oferta del logotipo' },
                    { style: { backgroundColor: '#dc3545', color: 'white' }, html: '❌ Sí, volver a Facebook', action: () => window.location.href='https://facebook.com' }
                ]
            }
        ];

        let currentSequence = []; // Almacena la secuencia de pasos actual
        let currentStepIndex = 0; // Índice del paso actual en la secuencia

        /**
         * Agrega un mensaje de texto al chatbox.
         * @param {string} contenido - El contenido del mensaje (puede ser HTML).
         * @param {boolean} esHTML - Indica si el contenido debe interpretarse como HTML.
         */
        function agregarMensaje(contenido, esHTML = false) {
            const p = document.createElement("p");
            p.className = "chat"; // Aplica la clase de burbuja de chat
            // Reemplaza el placeholder {keyword} con la palabra clave real
            const finalContent = contenido.replace(/{keyword}/g, userSearchKeyword);
            if (esHTML) {
                p.innerHTML = finalContent;
            } else {
                p.textContent = finalContent;
            }
            chatbox.appendChild(p);
            // Desplaza el chatbox al final para ver el nuevo mensaje
            chatbox.scrollTop = chatbox.scrollHeight;
        }

        /**
         * Inicia una secuencia de mensajes o elementos.
         * @param {Array<Object>} sequence - La secuencia de pasos a mostrar.
         */
        function startSequence(sequence) {
            currentSequence = sequence;
            currentStepIndex = 0;
            mostrarElementosConRetraso();
        }

        // Funciones globales para las acciones de los botones
        function triggerPriceReveal() {
            startSequence(priceRevealSteps);
        }

        function triggerLastChanceSequence() {
            startSequence(lastChanceSteps);
        }

        function restartChat() {
            chatbox.innerHTML = ''; // Limpia el chatbox
            startSequence(conversationSteps); // Reinicia la conversación principal
        }

        /**
         * Muestra los elementos de la secuencia actual con un retraso, simulando la escritura.
         */
        function mostrarElementosConRetraso() {
            // Si ya no quedan pasos en la secuencia actual, oculta el indicador de escritura y termina.
            if (currentStepIndex >= currentSequence.length) {
                typing.style.display = "none";
                return;
            }

            const elementoActual = currentSequence[currentStepIndex];
            // Usa el retraso específico del elemento o un valor predeterminado de 3 segundos.
            const delay = elementoActual.delay || 3000;

            typing.style.display = "block"; // Muestra el indicador de "escribiendo"
            chatbox.scrollTop = chatbox.scrollHeight; // Desplaza para ver el indicador

            setTimeout(() => {
                typing.style.display = "none"; // Oculta el indicador

                // Maneja diferentes tipos de elementos en la conversación
                if (elementoActual.type === 'message') {
                    agregarMensaje(elementoActual.content, elementoActual.isHTML);
                } else if (elementoActual.type === 'image') {
                    // Crea una burbuja de chat para la imagen
                    const imgBubble = document.createElement('p');
                    imgBubble.className = 'chat';
                    const img = document.createElement('img');
                    img.src = elementoActual.src;
                    img.alt = elementoActual.alt;
                    // Manejo de error para imágenes
                    img.onerror = function() { this.onerror=null; this.src='https://placehold.co/300x200/FF0000/FFFFFF?text=Error+Carga'; };
                    imgBubble.appendChild(img);
                    chatbox.appendChild(imgBubble);
                    chatbox.scrollTop = chatbox.scrollHeight;
                } else if (elementoActual.type === 'clickable-image') {
                    // Crea una burbuja de chat para la imagen clicable
                    const imgBubble = document.createElement('p');
                    imgBubble.className = 'chat';
                    const img = document.createElement('img');
                    img.src = elementoActual.src;
                    img.alt = elementoActual.alt;
                    img.style.cursor = "pointer"; // Hace que el cursor indique que es clicable
                    // Manejo de error para imágenes
                    img.onerror = function() { this.onerror=null; this.src='https://placehold.co/300x200/FFA500/FFFFFF?text=Error+Carga'; };
                    // Asigna la acción de clic a la función global especificada
                    img.onclick = window[elementoActual.action];
                    imgBubble.appendChild(img);
                    chatbox.appendChild(imgBubble);
                    chatbox.scrollTop = chatbox.scrollHeight;
                } else if (elementoActual.type === 'audio-simulated') {
                    // Paso 1: Muestra el mensaje "Grabando Audio..."
                    const grabandoMsg = document.createElement("p");
                    grabandoMsg.className = "chat audio-placeholder";
                    grabandoMsg.textContent = "Grabando Audio...";
                    grabandoMsg.id = "grabandoAudio"; // Asigna un ID para poder eliminarlo fácilmente
                    chatbox.appendChild(grabandoMsg);
                    chatbox.scrollTop = chatbox.scrollHeight;

                    // Paso 2: Después de un retraso, elimina "Grabando Audio..." y muestra el reproductor de audio real
                    setTimeout(() => {
                        const oldGrabando = document.getElementById("grabandoAudio");
                        if (oldGrabando) {
                            oldGrabando.remove(); // Elimina el mensaje "Grabando Audio..."
                        }

                        const audioBubble = document.createElement("div");
                        audioBubble.className = "audio-message"; // Aplica los estilos de burbuja de chat
                        const audio = document.createElement("audio");
                        audio.controls = true; // Muestra los controles de audio
                        audio.autoplay = true; // Reproduce el audio automáticamente
                        audio.src = elementoActual.audioSrc;
                        // Manejo de error para el audio
                        audio.onerror = function() {
                            console.error("Error al cargar el audio:", this.src);
                            const errorMsg = document.createElement("span");
                            errorMsg.textContent = " (Error al cargar el audio)";
                            errorMsg.style.color = "red";
                            audioBubble.appendChild(errorMsg);
                        };
                        audioBubble.appendChild(audio);
                        chatbox.appendChild(audioBubble);
                        chatbox.scrollTop = chatbox.scrollHeight;

                        // Paso 3: Después de la duración simulada del audio, procede al siguiente paso en la secuencia
                        setTimeout(() => {
                            currentStepIndex++;
                            mostrarElementosConRetraso();
                        }, elementoActual.audioDuration || 10000); // Duración predeterminada del audio si no se especifica
                    }, 3000); // Retraso antes de mostrar el reproductor de audio (simula tiempo de "grabación")
                    return; // Importante: Salir para evitar que el setTimeout exterior llame al siguiente paso inmediatamente
                } else if (elementoActual.type === 'buttons') {
                    // Crea una burbuja de chat para contener los botones
                    const buttonsBubble = document.createElement('p');
                    buttonsBubble.className = 'chat';
                    buttonsBubble.style.padding = '0'; // Elimina el padding de la burbuja para que los botones lo controlen
                    buttonsBubble.style.backgroundColor = 'transparent'; // Fondo transparente para la burbuja de botones
                    buttonsBubble.style.boxShadow = 'none'; // Sin sombra para la burbuja de botones
                    buttonsBubble.style.alignSelf = 'flex-start'; // Alinea la burbuja de botones a la izquierda

                    const btnBox = document.createElement("div");
                    btnBox.className = "button-box w-full"; // button-box ya tiene estilos de flex y gap
                    btnBox.style.padding = '0'; // Elimina el padding extra del button-box si ya lo tiene la burbuja
                    btnBox.style.backgroundColor = 'transparent'; // Asegura que el fondo sea transparente

                    buttonsBubble.appendChild(btnBox); // Añade el contenedor de botones a la burbuja
                    chatbox.appendChild(buttonsBubble); // Añade la burbuja al chatbox
                    chatbox.scrollTop = chatbox.scrollHeight;

                    const totalButtons = elementoActual.buttons.length;
                    let buttonsRendered = 0;

                    // Itera sobre los botones y los añade con un retraso individual
                    elementoActual.buttons.forEach((buttonData, index) => {
                        setTimeout(() => {
                            const button = document.createElement("button");
                            button.className = `button ${buttonData.className || ''}`;
                            if (buttonData.style) {
                                for (const prop in buttonData.style) {
                                    button.style[prop] = buttonData.style[prop];
                                }
                            }
                            button.innerHTML = buttonData.html;
                            // Maneja las acciones de los botones: si es una cadena, asume una función global o URL directa
                            if (typeof buttonData.action === 'string') {
                                if (buttonData.action.startsWith('window.location.href')) {
                                    button.onclick = () => eval(buttonData.action); // Evalúa la cadena como código JS
                                } else {
                                    button.onclick = window[buttonData.action]; // Llama a la función global por su nombre
                                }
                            } else if (typeof buttonData.action === 'function') {
                                button.onclick = buttonData.action; // Asigna la referencia directa a la función
                            }
                            btnBox.appendChild(button);
                            chatbox.scrollTop = chatbox.scrollHeight;

                            buttonsRendered++;
                            // Si todos los botones de este elemento han sido renderizados, procede al siguiente paso principal
                            if (buttonsRendered === totalButtons) {
                                currentStepIndex++;
                                mostrarElementosConRetraso();
                            }
                        }, index * 2000); // Retraso de 2 segundos entre botones
                    });
                    return; // Importante: Salir para evitar que el setTimeout exterior llame al siguiente paso inmediatamente
                }

                // Si el elemento no es de tipo 'audio-simulated' o 'buttons', procede al siguiente paso
                currentStepIndex++;
                mostrarElementosConRetraso();
            }, delay); // Retraso para el elemento actual
        }

        // Inicia la conversación cuando el DOM esté completamente cargado
        document.addEventListener("DOMContentLoaded", function () {
            chatbox.innerHTML = ''; // Limpia el chatbox una sola vez al cargar la página
            startSequence(conversationSteps); // Inicia la secuencia de conversación principal
        });
    </script>
</body>
</html>
