<?php
// db/services-delete.php
ob_start(); // Iniciar el búfer de salida
error_reporting(0); // Desactivar la muestra de errores en producción
ini_set('display_errors', 0); // Desactivar la muestra de errores en producción

include_once 'db_connection.php'; // Incluir el archivo de conexión a la base de datos

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en services-delete.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }

    $id = (int)($input['id'] ?? 0); // ID de la base de datos

    if (empty($id)) {
        $response['message'] = 'ID de servicio es obligatorio para eliminar.';
        echo json_encode($response);
        exit();
    }

    try {
        $pdo->beginTransaction();

        // La cláusula ON DELETE CASCADE en client_services se encargará de eliminar
        // los registros de asociación de este servicio con clientes automáticamente.
        $stmt = $pdo->prepare("DELETE FROM services WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            $response['success'] = true;
            $response['message'] = 'Servicio eliminado con éxito.';
        } else {
            $response['message'] = 'Error al eliminar el servicio de la base de datos.';
        }
        $pdo->commit();

    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Error PDO al eliminar servicio: " . $e->getMessage());
        $response['message'] = 'Error de Base de Datos al eliminar servicio: ' . $e->getMessage();
        if ($e->getCode() == 23000) { // Si hay una restricción FOREIGN KEY
            $response['message'] = 'No se puede eliminar el servicio porque está asignado a uno o más clientes.';
        }
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Error general al eliminar servicio: " . $e->getMessage());
        $response['message'] = 'Error inesperado al eliminar servicio: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

ob_end_clean(); // Limpiar el búfer de salida
header('Content-Type: application/json'); // Establecer el tipo de contenido a JSON
echo json_encode($response); // Enviar la respuesta JSON
exit; // Terminar la ejecución del script