<?php
// db/upload-profile-photo.php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Asumimos que solo hay UN administrador y su ID es 1.
    $admin_id = 1; // ¡CAMBIA ESTO SI TU ADMINISTRADOR TIENE UN ID DIFERENTE!

    if (!isset($_FILES['profile_photo']) || $_FILES['profile_photo']['error'] !== UPLOAD_ERR_OK) {
        $response['message'] = 'Error al subir el archivo: ' . (isset($_FILES['profile_photo']['error']) ? $_FILES['profile_photo']['error'] : 'Error desconocido.');
        echo json_encode($response);
        exit();
    }

    $file = $_FILES['profile_photo'];
    // Ajustado el directorio de destino para que apunte a 'uploads/profile_photos/' desde la raíz del proyecto
    $target_dir = "../uploads/profile_photos/";
    $imageFileType = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    $unique_filename = uniqid('profile_', true) . '.' . $imageFileType;
    $target_file = $target_dir . $unique_filename;

    // Verificar si el directorio de destino existe y es escribible; si no, intentar crearlo.
    if (!is_dir($target_dir)) {
        if (!mkdir($target_dir, 0755, true)) {
            $response['message'] = 'Error: No se pudo crear el directorio de subida. Verifica los permisos: ' . $target_dir;
            echo json_encode($response);
            exit();
        }
    } elseif (!is_writable($target_dir)) {
        $response['message'] = 'Error: El directorio de subida no tiene permisos de escritura: ' . $target_dir;
        echo json_encode($response);
        exit();
    }

    // Verificar si el archivo es una imagen real
    $check = getimagesize($file["tmp_name"]);
    if ($check === false) {
        $response['message'] = "El archivo no es una imagen válida o está corrupto.";
        echo json_encode($response);
        exit();
    }

    // Permitir ciertos formatos de archivo
    $allowed_types = array("jpg", "jpeg", "png", "gif");
    if (!in_array($imageFileType, $allowed_types)) {
        $response['message'] = "Tipo de archivo no permitido. Solo se aceptan JPG, JPEG, PNG y GIF.";
        echo json_encode($response);
        exit();
    }

    // Validar el tamaño del archivo (ej. 5MB máximo)
    if ($file["size"] > 5 * 1024 * 1024) { // 5 MB
        $response['message'] = "El archivo es demasiado grande (máximo 5MB).";
        echo json_encode($response);
        exit();
    }

    try {
        // Obtener la URL de la foto antigua del administrador para eliminarla si se sube una nueva.
        $stmt_old_photo = $pdo->prepare("SELECT profile_photo_url FROM admin WHERE id = :id");
        $stmt_old_photo->bindParam(':id', $admin_id, PDO::PARAM_INT);
        $stmt_old_photo->execute();
        $old_photo_data = $stmt_old_photo->fetch();
        $old_photo_full_path = null;

        if ($old_photo_data && !empty($old_photo_data['profile_photo_url'])) {
            // Construye la ruta completa al archivo antiguo en el servidor
            $old_photo_full_path = '../' . $old_photo_data['profile_photo_url'];
        }

        // Mover el archivo subido a su destino final
        if (move_uploaded_file($file["tmp_name"], $target_file)) {
            // La URL para guardar en la base de datos es relativa a la raíz del proyecto
            $photo_url_for_db = 'uploads/profile_photos/' . $unique_filename; 

            // Actualizar la URL de la foto de perfil del administrador en la base de datos
            $stmt_update = $pdo->prepare("UPDATE admin SET profile_photo_url = :photo_url, updated_at = NOW() WHERE id = :id");
            $stmt_update->bindParam(':photo_url', $photo_url_for_db);
            $stmt_update->bindParam(':id', $admin_id, PDO::PARAM_INT);
            
            if ($stmt_update->execute()) {
                $response['success'] = true;
                $response['message'] = 'Foto de perfil subida y URL actualizada con éxito.';
                $response['file_url'] = $photo_url_for_db; // Devolver la URL relativa al frontend

                // Si la subida y actualización de la DB fueron exitosas, elimina la foto anterior si existía.
                if ($old_photo_full_path && file_exists($old_photo_full_path) && is_file($old_photo_full_path)) {
                    @unlink($old_photo_full_path); // Usamos @ para suprimir errores si no se puede eliminar (ej. permisos)
                }

            } else {
                // Si la actualización de la DB falla, intentar eliminar la foto recién subida para evitar basura.
                if (file_exists($target_file)) {
                    @unlink($target_file);
                }
                $response['message'] = 'Error al actualizar la URL de la foto en la base de datos después de la subida.';
            }
        } else {
            $response['message'] = 'Error al mover el archivo subido. Verifica los permisos de la carpeta ' . $target_dir;
        }
    } catch (PDOException $e) {
        // Si hay un error de DB, intentar eliminar la foto recién subida si ya se había movido.
        if (file_exists($target_file)) {
            @unlink($target_file);
        }
        error_log("Error PDO al subir foto: " . $e->getMessage());
        $response['message'] = 'Error de base de datos durante la subida de foto: ' . $e->getMessage();
    } catch (Exception $e) {
        error_log("Error general al subir foto: " . $e->getMessage());
        $response['message'] = 'Error inesperado durante la subida de foto: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>