<?php
// db/user-password-update.php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en user-password-update.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }
    if (empty($input) || empty($input['current_password']) || empty($input['new_password'])) {
        $response['message'] = 'Faltan datos obligatorios (contraseña actual y nueva contraseña).';
        echo json_encode($response);
        exit();
    }

    // Asumimos que actualizaremos la contraseña del administrador con ID 1.
    $admin_id = 1; // ¡CAMBIA ESTO SI TU ADMINISTRADOR TIENE UN ID DIFERENTE!

    $current_password = $input['current_password'];
    $new_password = $input['new_password'];

    if (strlen($new_password) < 6) {
        $response['message'] = 'La nueva contraseña debe tener al menos 6 caracteres.';
        echo json_encode($response);
        exit();
    }

    try {
        $pdo->beginTransaction();

        // Primero, obtenemos el hash de la contraseña actual del administrador
        $stmt = $pdo->prepare("SELECT password FROM admin WHERE id = :id");
        $stmt->bindParam(':id', $admin_id, PDO::PARAM_INT);
        $stmt->execute();
        $admin_data = $stmt->fetch();

        if ($admin_data && password_verify($current_password, $admin_data['password'])) {
            // La contraseña actual es correcta, generamos el hash de la nueva contraseña
            $hashed_new_password = password_hash($new_password, PASSWORD_DEFAULT);

            // Actualizamos la contraseña en la base de datos
            $stmt_update = $pdo->prepare("UPDATE admin SET password = :new_password, updated_at = NOW() WHERE id = :id");
            $stmt_update->bindParam(':new_password', $hashed_new_password);
            $stmt_update->bindParam(':id', $admin_id, PDO::PARAM_INT);
            
            if ($stmt_update->execute()) {
                $response['success'] = true;
                $response['message'] = 'Contraseña actualizada con éxito.';
            } else {
                $response['message'] = 'Error al actualizar la contraseña en la base de datos.';
            }
        } else {
            $response['message'] = 'Contraseña actual incorrecta.';
        }
        $pdo->commit();

    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Error PDO al actualizar contraseña de administrador: " . $e->getMessage());
        $response['message'] = 'Error de Base de Datos al actualizar contraseña: ' . $e->getMessage();
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Error general al actualizar contraseña de administrador: " . $e->getMessage());
        $response['message'] = 'Error interno al actualizar contraseña: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>