<?php
// db/user-profile-update.php
ob_start();
// Opcional: Desactivar errores en produccin. db_connection.php ya los maneja para depuracin.
error_reporting(0); 
ini_set('display_errors', 0);

// Incluir el archivo de conexin a la base de datos desde la misma carpeta 'db/'
include_once 'db_connection.php';
// NOTA: 'file_helpers.php' y 'deleteFileFromServer' han sido eliminados de aqu,
// ya que la lgica de eliminacin de fotos antiguas se gestiona en 'upload-profile-photo.php'.

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en user-profile-update.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }
    if (empty($input)) {
        $response['message'] = 'Datos de solicitud vacos o no vlidos.';
        echo json_encode($response);
        exit();
    }

    // Asumimos que actualizaremos el perfil del administrador con ID 1.
    $admin_id = 1; // 03CAMBIA ESTO SI TU ADMINISTRADOR TIENE UN ID DIFERENTE!

    $full_name = trim($input['full_name'] ?? '');
    // La URL de la foto se recibe y se guarda directamente, la eliminacin de la antigua se hace en upload-profile-photo.php
    $new_profile_photo_url = trim($input['profile_photo_url'] ?? null); 

    if (empty($full_name)) {
        $response['message'] = 'El nombre completo es obligatorio.';
        echo json_encode($response);
        exit();
    }

    try {
        $pdo->beginTransaction();

        // Actualizar el perfil del administrador en la base de datos (TABLA 'admin')
        $stmt_update = $pdo->prepare("UPDATE admin SET full_name = :full_name, profile_photo_url = :photo_url, updated_at = NOW() WHERE id = :id");
        $stmt_update->bindParam(':full_name', $full_name);
        $stmt_update->bindParam(':photo_url', $new_profile_photo_url);
        $stmt_update->bindParam(':id', $admin_id, PDO::PARAM_INT);
        $stmt_update->execute();

        $pdo->commit();

        $response['success'] = true;
        $response['message'] = 'Informacin personal actualizada con xito.';

    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Error PDO al actualizar perfil de administrador: " . $e->getMessage());
        $response['message'] = 'Error de Base de Datos al actualizar perfil: ' . $e->getMessage();
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Error general al actualizar perfil de administrador: " . $e->getMessage());
        $response['message'] = 'Error interno al actualizar perfil: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Mtodo de solicitud no vlido.';
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit();
?>