<?php
header('Content-Type: application/json');

// --- DEFINE TU API KEY DIRECTAMENTE AQUÍ (FUSIONADO DESDE config.php) ---
define('GEMINI_API_KEY', 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw');

// Verifica que la API Key no esté vacía.
if (empty(GEMINI_API_KEY)) {
    http_response_code(500);
    echo json_encode(['error' => 'La API Key de Gemini está vacía. Por favor, asegúrate de que el valor de GEMINI_API_KEY es correcto.']);
    exit;
}

$apiKey = GEMINI_API_KEY;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido. Utiliza POST.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar que los datos requeridos estén presentes
$required_fields = ['user_name', 'company_name', 'client_name', 'service_type', 'last_service_date', 'message_type'];
foreach ($required_fields as $field) {
    if (!isset($data[$field]) || trim($data[$field]) === '') {
        http_response_code(400);
        echo json_encode(['error' => "Falta el campo requerido: '{$field}'. Asegúrate de completar todos los datos."]);
        exit;
    }
}

$user_name = $data['user_name'];
$company_name = $data['company_name'];
$client_name = $data['client_name'];
$service_type = $data['service_type'];
$last_service_date = $data['last_service_date'];
$service_detail = $data['service_detail'] ?? ''; // Opcional
$message_type = $data['message_type'];

$message_purpose = '';
$tip_purpose = '';

switch ($message_type) {
    case '1day':
        $message_purpose = "un mensaje de seguimiento amable después de 1 día del servicio para confirmar su satisfacción con el trabajo realizado y abrir un canal de comunicación para cualquier comentario.";
        $tip_purpose = "Un consejo para este tipo de mensaje es enfatizar la satisfacción y la apertura al feedback para construir confianza.";
        break;
    case '3-5days':
        $message_purpose = "un mensaje de seguimiento sutil después de 3 a 5 días del servicio. El objetivo es un recordatorio amigable del servicio y sus beneficios, sin ser insistente, y recordar que estás disponible para futuras necesidades.";
        $tip_purpose = "Un consejo para este tipo de mensaje es recordar el beneficio del servicio y ofrecer ayuda sin presionar para una nueva contratación.";
        break;
    case '7-10days':
        $message_purpose = "un mensaje de seguimiento estratégico después de 7 a 10 días del servicio para invitar amablemente a la próxima contratación o a considerar otros servicios, basándose en la buena experiencia anterior.";
        $tip_purpose = "Un consejo para este tipo de mensaje es conectar la invitación a la contratación con el éxito del servicio anterior y el beneficio que el cliente obtuvo.";
        break;
    default:
        http_response_code(400);
        echo json_encode(['error' => 'Tipo de mensaje de seguimiento no válido.']);
        exit;
}

// --- PROMPT MAESTRO para el Generador de Mensajes de Seguimiento - CORREGIDO PARA CAMPOS ---
$prompt = "
Actúa como un experto en comunicación y ventas para negocios de servicios locales.
Tu tarea es generar un mensaje de seguimiento personalizado para un cliente, así como un consejo relevante para el dueño del negocio.

Aquí está el contexto del servicio y el cliente, y DEBES usar estos VALORES directamente en los mensajes:
- Tu Nombre: \"{$user_name}\"
- Nombre de Tu Negocio: \"{$company_name}\"
- Nombre del Cliente: \"{$client_name}\"
- Tipo de Servicio Realizado: \"{$service_type}\"
- Fecha del Último Servicio: \"{$last_service_date}\"
" . (!empty($service_detail) ? "- Detalle Opcional del Servicio (Recordatorio): \"{$service_detail}\"\n" : "") . "

Tu tarea es generar:
1.  Un \"spanish_message\": El mensaje de seguimiento en español para el cliente, cuyo propósito es {$message_purpose}. Debe ser personalizado, amable y profesional. DEBE usar el Nombre del Cliente, Tipo de Servicio, Tu Nombre y Nombre de Tu Negocio **DIRECTAMENTE** de los datos proporcionados. Debe referirse al servicio específico y a la fecha si es relevante.
2.  Un \"english_message\": La traducción de ese mensaje al inglés, aplicando las mismas reglas.
3.  Un \"tip\": Un consejo práctico para el dueño del negocio sobre la estrategia de este tipo de mensaje. {$tip_purpose}

Directrices para los mensajes:
- El tono debe ser cálido, profesional y genuino.
- Los mensajes deben ser concisos y directos, apropiados para WhatsApp o Messenger.
- Deben terminar con un saludo de tu nombre y el nombre de tu negocio.
- Utiliza saltos de línea (\\n) para formatear el mensaje.
- **PROHIBIDO ESTRICTAMENTE:** No utilices NINGÚN marcador de posición con corchetes `[]` o `{}`, como `[Client Name]`, `[Service Type]`, etc. en la salida de los mensajes. Usa los VALORES que te he dado.

Asegúrate de que la salida sea un objeto JSON válido con las claves \"spanish_message\", \"english_message\", y \"tip\".
";

$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

$payload = [
    'contents' => [['parts' => [['text' => $prompt]]]],
    'generationConfig' => [
        'response_mime_type' => 'application/json',
        'response_schema' => [
            'type' => 'OBJECT',
            'properties' => [
                'spanish_message' => ['type' => 'STRING'],
                'english_message' => ['type' => 'STRING'],
                'tip' => ['type' => 'STRING']
            ],
            'required' => ['spanish_message', 'english_message', 'tip']
        ]
    ]
];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

if ($response === false || $http_code !== 200) {
    http_response_code(500);
    $error_details = $curl_error ?: ($response ? json_decode($response, true) : 'Respuesta de la API vacía o ilegible.');
    echo json_encode([
        'error' => 'No se pudo obtener una respuesta de la IA. Posiblemente un problema de conexión o API Key.',
        'http_code' => $http_code,
        'curl_error' => $curl_error,
        'raw_response_from_ai' => $response,
        'details' => $error_details
    ]);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'] ?? '';

$generated_text = str_replace(['```json', '```'], '', $generated_text);
$final_data = json_decode(trim($generated_text), true);

if ($final_data === null || !isset($final_data['spanish_message']) || !isset($final_data['english_message']) || !isset($final_data['tip'])) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA devolvió un formato de JSON inválido o no contiene los campos esperados (spanish_message, english_message, tip).',
        'raw_ai_response_after_trim' => trim($generated_text),
        'decoded_data_debug' => $final_data
    ]);
    exit;
}

echo json_encode($final_data);
?>