<?php
// Muestra errores para depuración - CÁMBIALO a 0 en producción
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Iniciar el buffer de salida para asegurar que NADA se imprima antes.
ob_start();

// Requerir archivos necesarios
// Asegúrate de que las rutas son correctas y que estos archivos NO imprimen nada.
include '../files/guardiankey.php'; // Ruta corregida si está en la carpeta 'api'
require_once '../db/db_connection.php'; // Conexión a la base de datos

// --- FUNCIÓN PARA OBTENER DATOS DE LA EMPRESA ---
// Esta función ahora también obtiene el 'email' y 'website_url'
function get_company_config($pdo) {
    try {
        $stmt = $pdo->query("SELECT contact_name, company_name, phone_primary, website_url, logo_url, email FROM website_config WHERE id = 1 LIMIT 1");
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: [];
    } catch (PDOException $e) {
        error_log("Error fetching website_config: " . $e->getMessage());
        return [];
    }
}

// --- LÓGICA PRINCIPAL DEL SCRIPT ---
$request_method = $_SERVER['REQUEST_METHOD'];

if ($request_method === 'POST') {
    // Si la solicitud es para generar texto con la IA
    header('Content-Type: application/json');
    header('Connection: close'); // Intenta cerrar la conexión rápidamente

    // Limpiar el buffer de salida ANTES de enviar la respuesta JSON.
    ob_end_clean();

    define('GEMINI_API_KEY', 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw'); // Asegúrate de que esta sea tu clave real

    if (empty(GEMINI_API_KEY) || GEMINI_API_KEY === 'TU_API_KEY_DE_GEMINI_AQUI') {
        http_response_code(500);
        echo json_encode(['error' => 'La API Key de Gemini no está configurada en el servidor.']);
        exit;
    }

    $data = json_decode(file_get_contents('php://input'), true);

    $required_fields = ['client_name', 'project_name', 'project_objective', 'key_deliverables', 'timeline', 'price', 'validity_period'];
    foreach ($required_fields as $field) {
        if (!isset($data[$field]) || trim($data[$field]) === '') {
            http_response_code(400);
            echo json_encode(['error' => "Falta el campo requerido: '{$field}'. Asegúrate de completar todos los datos."]);
            exit;
        }
    }

    $companyConfig = get_company_config($pdo);
    $your_name = $companyConfig['contact_name'] ?? $data['your_name'];
    $your_company = $companyConfig['company_name'] ?? $data['your_company'];
    $client_company = !empty(trim($data['client_company'])) ? $data['client_company'] : 'No especificada';

    // Prompt para Gemini
    $prompt = "
    Actúa como un consultor de negocios y experto en redacción de propuestas comerciales, totalmente bilingüe (español e inglés).
    **Contexto del Negocio y Cliente:**
    - **Mi Nombre/Empresa:** {$your_name} de {$your_company}
    - **Nombre del Cliente:** {$data['client_name']}
    - **Empresa del Cliente:** {$client_company}
    - **Nombre del Proyecto:** {$data['project_name']}
    - **Objetivo Principal del Proyecto:** {$data['project_objective']}
    - **Entregables Clave (Scope):** {$data['key_deliverables']}
    - **Plazo de Entrega Estimado:** {$data['timeline']}
    - **Inversión Total del Proyecto:** \${$data['price']}
    - **Validez de la Propuesta:** {$data['validity_period']}
    **Tu Tarea Específica:**
    Genera DOS versiones completas y profesionales de la propuesta de proyecto: una en **español** y otra en **inglés**.
    **Formato de Títulos (Regla Importante para AMBOS idiomas):**
    Para los títulos de cada sección, utiliza el siguiente formato exacto con emojis y asteriscos para negrita, por ejemplo:
    *🚀 Introducción* (Spanish)
    *🚀 Introduction* (English)

    Aquí está la lista completa de títulos que debes usar:
    - *🚀 Introducción* (Spanish) / *🚀 Introduction* (English)
    - *🎯 Entendimiento del Objetivo* (Spanish) / *🎯 Understanding The Objective* (English)
    - *💡 Solución Propuesta* (Spanish) / *💡 Proposed Solution* (English)
    - *📦 Alcance y Entregables Clave* (Spanish) / *📦 Scope & Key Deliverables* (English)
    - *⏳ Plazo de Ejecución* (Spanish) / *⏳ Timeline* (English)
    - *💰 Inversión* (Spanish) / *💰 Investment* (English)
    - *👉 Próximos Pasos* (Spanish) / *👉 Next Steps* (English)

    Asegúrate de que los textos de las propuestas usen saltos de línea (\\n) para separar párrafos.

    **Formato de Salida Requerido:**
    La respuesta DEBE ser un único objeto JSON válido con dos claves: `proposal_spanish` y `proposal_english`. El valor de cada clave será un string que contenga la propuesta completa en el idioma correspondiente, formateada con saltos de línea (`\\n`).
    ";

    $apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . GEMINI_API_KEY;
    $payload = [
        'contents' => [['parts' => [['text' => $prompt]]]],
        'generationConfig' => [
            'response_mime_type' => 'application/json',
            'response_schema' => [
                'type' => 'OBJECT',
                'properties' => [
                    'proposal_spanish' => ['type' => 'STRING'],
                    'proposal_english' => ['type' => 'STRING']
                ],
                'required' => ['proposal_spanish', 'proposal_english']
            ]
        ]
    ];

    $ch = curl_init($apiUrl);
    curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => true, CURLOPT_POSTFIELDS => json_encode($payload), CURLOPT_HTTPHEADER => ['Content-Type: application/json']]);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code !== 200) {
        http_response_code(500);
        echo json_encode(['error' => 'No se pudo obtener una respuesta de la IA.', 'details' => json_decode($response)]);
        exit;
    }

    $result_text = json_decode($response, true)['candidates'][0]['content']['parts'][0]['text'] ?? '';
    $final_data = json_decode(trim(str_replace(['```json', '```'], '', $result_text)), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(500);
        echo json_encode(['error' => 'La IA devolvió un formato de JSON inválido.', 'raw_response' => $result_text, 'json_last_error' => json_last_error_msg()]);
        exit;
    }

    echo json_encode($final_data);
    exit;
}

// Si no es una solicitud POST válida
http_response_code(405);
echo json_encode(['error' => 'Método no permitido.']);
?>