<?php
// db/clients-create.php

// ***** IMPORTANTE: ESTAS LÍNEAS ESTÁN AQUÍ PARA DEPURAR. *****
// UNA VEZ QUE FUNCIONE, CÁMBIALAS A: error_reporting(0); ini_set('display_errors', 0);
error_reporting(E_ALL); // Reporta todos los errores
ini_set('display_errors', 1); // Muestra los errores en la pantalla
// *************************************************************

session_start();
header('Content-Type: application/json');

include_once 'db_connection.php'; // Asegúrate de que esta ruta sea correcta
include_once 'client-services-sync.php'; // Incluir la función de sincronización de servicios

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    // Verificar errores en la decodificación JSON o si los datos de entrada están vacíos
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en clients-create.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }
    if (empty($input)) {
        error_log("Datos de entrada vacíos o JSON inválido en clients-create.php.");
        $response['message'] = 'Datos de solicitud vacíos o no válidos.';
        echo json_encode($response);
        exit();
    }

    $first_name = trim($input['first_name'] ?? '');
    $last_name = trim($input['last_name'] ?? '');
    $email = trim($input['email'] ?? '');
    
    // Convertir cadenas vacías a NULL para campos opcionales antes de la validación y el uso
    $phone = !empty(trim($input['phone'] ?? '')) ? trim($input['phone']) : null;
    $mobile = !empty(trim($input['mobile'] ?? '')) ? trim($input['mobile']) : null;
    $street_address = !empty(trim($input['street_address'] ?? '')) ? trim($input['street_address']) : null;
    $city = !empty(trim($input['city'] ?? '')) ? trim($input['city']) : null;
    $state_province = !empty(trim($input['state_province'] ?? '')) ? trim($input['state_province']) : null;
    $zip_code = !empty(trim($input['zip_code'] ?? '')) ? trim($input['zip_code']) : null;
    
    $assigned_service_ids = is_array($input['assigned_service_ids'] ?? null) ? $input['assigned_service_ids'] : []; 
    
    // Asegurarse de que el ID del prospecto esté limpio
    $prospect_id_to_delete = trim($input['prospect_id'] ?? ''); 

    // Campo is_recurring
    // SOLUCIÓN FINAL: Castear explícitamente a (int) para asegurar 0 o 1.
    // Esto maneja el caso de un checkbox desmarcado (que no envía el valor) o un 'false'.
    $is_recurring = isset($input['is_recurring']) ? (int)(bool)$input['is_recurring'] : 0;

    // Validar datos básicos
    if (empty($first_name)) {
        $response['message'] = 'El nombre del cliente es obligatorio.';
        echo json_encode($response);
        exit();
    }

    // Validación de campos requeridos adicionales
    if (empty($email)) {
        $response['message'] = 'El email del cliente es obligatorio.';
        echo json_encode($response);
        exit();
    }
    
    // Al menos un número de teléfono (fijo o móvil) debe ser provisto
    if (empty($phone) && empty($mobile)) {
        $response['message'] = 'Se requiere al menos un número de teléfono (fijo o celular).';
        echo json_encode($response);
        exit();
    }


    try {
        // --- PRE-VERIFICACIÓN DE DUPLICADOS EN LA TABLA 'clients' ---
        // Verificar email duplicado (solo si se proporciona)
        if (!empty($email)) {
            $stmtCheckEmail = $pdo->prepare("SELECT COUNT(*) FROM clients WHERE email = ?");
            $stmtCheckEmail->execute([$email]);
            if ($stmtCheckEmail->fetchColumn() > 0) {
                $response['message'] = 'Error: El email "' . $email . '" ya está registrado para otro cliente.';
                echo json_encode($response);
                exit();
            }
        }

        // Verificar teléfono fijo duplicado (si se proporciona y no es NULL)
        if ($phone !== null) { // Cambiado para verificar si es realmente un valor no nulo
            $stmtCheckPhone = $pdo->prepare("SELECT COUNT(*) FROM clients WHERE phone = ?");
            $stmtCheckPhone->execute([$phone]);
            if ($stmtCheckPhone->fetchColumn() > 0) {
                $response['message'] = 'Error: El número de teléfono fijo "' . $phone . '" ya está registrado para otro cliente.';
                echo json_encode($response);
                exit();
            }
        }
        
        // **NUEVA VERIFICACIÓN REVISADA: Teléfono móvil duplicado (si se proporciona y no es NULL)**
        // Esto es crucial para tu esquema de DB, ya que 'mobile' es UNIQUE.
        if ($mobile !== null) { // Cambiado para verificar si es realmente un valor no nulo
            $stmtCheckMobile = $pdo->prepare("SELECT COUNT(*) FROM clients WHERE mobile = ?");
            $stmtCheckMobile->execute([$mobile]);
            if ($stmtCheckMobile->fetchColumn() > 0) {
                $response['message'] = 'Error: El número de celular "' . $mobile . '" ya está registrado para otro cliente.';
                echo json_encode($response);
                exit();
            }
        }
        // --- FIN DE PRE-VERIFICACIÓN DE DUPLICADOS ---


        $pdo->beginTransaction(); // Iniciar una transacción para asegurar la atomicidad de las operaciones

        // 1. Insertar el nuevo cliente en la tabla 'clients'
        $stmt = $pdo->prepare("INSERT INTO clients (first_name, last_name, email, phone, mobile, street_address, city, state_province, zip_code, is_recurring) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$first_name, $last_name, $email, $phone, $mobile, $street_address, $city, $state_province, $zip_code, $is_recurring]);

        $client_id = $pdo->lastInsertId(); // Obtener el ID del cliente recién insertado.

        // 2. Sincronizar los servicios asignados para el nuevo cliente.
        if (!syncClientServices($pdo, (int)$client_id, $assigned_service_ids)) {
            throw new Exception("Error al sincronizar servicios para el nuevo cliente.");
        }

        // 3. Si se proporcionó un ID de prospecto, eliminarlo de la tabla 'leads'
        if (!empty($prospect_id_to_delete)) {
            $stmtDeleteLead = $pdo->prepare("DELETE FROM leads WHERE id = ?");
            $stmtDeleteLead->execute([$prospect_id_to_delete]);
            if ($stmtDeleteLead->rowCount() === 0) {
                error_log("Advertencia: Prospecto con ID '{$prospect_id_to_delete}' no encontrado para eliminar. (Puede que ya se haya borrado o el ID no coincida exactamente)");
            } else {
                error_log("Prospecto con ID '{$prospect_id_to_delete}' eliminado con éxito de leads.");
            }
        }

        $pdo->commit(); // Confirmar la transacción si todo fue exitoso.
        $response['success'] = true;
        $response['message'] = 'Cliente agregado con éxito.';
        
        // Devolver el objeto cliente completo, incluyendo los IDs de servicios asignados
        $response['client'] = [
            'id' => (int)$client_id, 
            'first_name' => $first_name,
            'last_name' => $last_name,
            'email' => $email,
            'phone' => $phone,
            'mobile' => $mobile,
            'street_address' => $street_address,
            'city' => $city,
            'state_province' => $state_province,
            'zip_code' => $zip_code,
            'assigned_service_ids' => $assigned_service_ids, 
            'created_at' => date('Y-m-d H:i:s'),
            'is_recurring' => $is_recurring 
        ];

    } catch (PDOException $e) {
        $pdo->rollBack(); 
        error_log("Error al crear cliente (PDO): " . $e->getMessage()); 
        // Si el error es de duplicado, el mensaje ya se manejó en la pre-verificación.
        // Si llega aquí, es otro tipo de error de DB.
        $response['message'] = 'Error de base de datos al agregar cliente: ' . $e->getMessage(); 
    } catch (Exception $e) {
        $pdo->rollBack(); 
        error_log("Error general al crear cliente: " . $e->getMessage()); 
        $response['message'] = 'Error interno al agregar cliente: ' . $e->getMessage(); 
    }
} else {
    error_log("clients-create.php: Solicitud recibida no es POST. Método: " . $_SERVER['REQUEST_METHOD']); 
    $response['message'] = 'Método de solicitud no válido.';
}

echo json_encode($response); 
exit();
?>