<?php
// db/invoice-delete.php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response = [];

try {
    $data = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Error: JSON inválido recibido. ' . json_last_error_msg());
    }

    // Validar que se ha recibido un ID de factura
    if (empty($data['id'])) {
        throw new Exception('ID de factura no proporcionado para la eliminación.');
    }

    $invoice_db_id = filter_var($data['id'], FILTER_VALIDATE_INT);

    if ($invoice_db_id === false) {
        throw new Exception('ID de factura inválido.');
    }

    $pdo->beginTransaction();

    // Eliminar la factura de la tabla 'invoices'
    // La eliminación en cascada de 'invoice_items' se manejará automáticamente por la FK si está bien configurada.
    $stmt = $pdo->prepare("DELETE FROM invoices WHERE id = ?");
    $stmt->execute([$invoice_db_id]);

    // Verificar si se eliminó alguna fila
    if ($stmt->rowCount() > 0) {
        $pdo->commit();
        $response = ['success' => true, 'message' => 'Factura eliminada con éxito.'];
    } else {
        $pdo->rollBack(); // No se eliminó nada, hacer rollback
        $response = ['success' => false, 'message' => 'La factura no fue encontrada o ya ha sido eliminada.'];
    }

} catch (PDOException $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    error_log("PDO Error en invoice-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => 'Error de Base de Datos: ' . $e->getMessage()];
} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    error_log("General Error en invoice-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => $e->getMessage()];
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>
