<?php
// db/lead-sources-create.php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response_data = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $source_name = trim($input['name'] ?? '');

    if (empty($source_name)) {
        $response_data['message'] = 'El nombre de la fuente no puede estar vacío.';
    } else {
        try {
            // Verificar si la fuente ya existe
            $stmt_check = $pdo->prepare("SELECT COUNT(*) FROM lead_sources WHERE name = :name");
            $stmt_check->execute([':name' => $source_name]);
            if ($stmt_check->fetchColumn() > 0) {
                $response_data['message'] = 'La fuente ya existe.';
            } else {
                $stmt = $pdo->prepare("INSERT INTO lead_sources (name) VALUES (:name)");
                if ($stmt->execute([':name' => $source_name])) {
                    $response_data['success'] = true;
                    $response_data['message'] = 'Fuente agregada exitosamente.';
                } else {
                    $response_data['message'] = 'Error al agregar la fuente.';
                }
            }
        } catch (PDOException $e) {
            error_log("Error PDO al crear fuente de lead: " . $e->getMessage());
            $response_data['message'] = 'Error de Base de Datos al crear fuente: ' . $e->getMessage();
        } catch (Exception $e) {
            error_log("Error general al crear fuente de lead: " . $e->getMessage());
            $response_data['message'] = 'Error inesperado al crear fuente: ' . $e->getMessage();
        }
    }
} else {
    $response_data['message'] = 'Método de solicitud no permitido.';
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response_data);
exit;
?>