<?php
ob_start();
session_start();

error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response = [];

try {
    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Error: JSON inválido recibido.');
    }
    if (!isset($data['id']) || empty($data['id'])) {
        throw new Exception('El ID del prospecto es requerido para la eliminación.');
    }

    $id = $data['id'];

    $stmt = $pdo->prepare("DELETE FROM leads WHERE id = ?");
    $stmt->execute([$id]);

    if ($stmt->rowCount() > 0) {
        $response = ['success' => true, 'message' => 'Prospecto eliminado con éxito.'];
    } else {
        $response = ['success' => false, 'message' => 'No se encontró el prospecto para eliminar.'];
    }

} catch (PDOException $e) {
    error_log("PDO Error en leads-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => 'Error de Base de Datos: ' . $e->getMessage()];
} catch (Exception $e) {
    error_log("General Error en leads-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => $e->getMessage()];
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit;