<?php
// db/leads-read-contact-data.php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response_data = ['success' => false, 'data' => []];

try {
    $stmt = $pdo->query("SELECT id, first_name, last_name, email, phone, mobile, company, street_address, city, state_province, zip_code FROM leads ORDER BY first_name ASC, last_name ASC");
    $leads = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $formatted_leads = [];
    foreach ($leads as $lead) {
        $full_name = trim($lead['first_name'] . ' ' . $lead['last_name']);
        $address_parts = [];
        if (!empty($lead['street_address'])) $address_parts[] = $lead['street_address'];
        if (!empty($lead['city'])) $address_parts[] = $lead['city'];
        if (!empty($lead['state_province'])) $address_parts[] = $lead['state_province'];
        if (!empty($lead['zip_code'])) $address_parts[] = $lead['zip_code'];
        $full_address = implode(', ', $address_parts);

        // MODIFICADO: Asegurarse de que 'address' siempre contenga la dirección física, no el nombre de la empresa.
        // El campo 'company' se mantiene separado para posible uso futuro si el usuario lo solicita.
        $formatted_leads[] = [
            'id' => $lead['id'], // El ID de lead es VARCHAR como en tu tabla leads
            'name' => $full_name,
            'email' => $lead['email'],
            'phone' => $lead['phone'],
            'mobile' => $lead['mobile'],
            'address' => $full_address, // Ahora siempre contendrá la dirección formateada
            'company' => $lead['company'], // Se añade el campo 'company' para mantener la información del negocio si se necesita más adelante.
            'type' => 'prospect'
        ];
    }

    $response_data = ['success' => true, 'data' => $formatted_leads];

} catch (PDOException $e) {
    error_log("Error PDO al cargar datos de prospectos para quotes: " . $e->getMessage());
    $response_data['message'] = 'Error de Base de Datos al cargar prospectos: ' . $e->getMessage();
} catch (Exception $e) {
    error_log("Error general al cargar datos de prospectos para quotes: " . $e->getMessage());
    $response_data['message'] = 'Error inesperado al cargar prospectos: ' . $e->getMessage();
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response_data);
exit;
?>