<?php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response = [];

try {
    $data = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Error: JSON inválido recibido.');
    }
    if (!isset($data['name']) || empty(trim($data['name']))) {
        throw new Exception('El nombre de la categoría es requerido.');
    }

    $name = trim($data['name']);

    // Verificar si la categoría ya existe
    $stmtCheck = $pdo->prepare("SELECT COUNT(*) FROM service_categories WHERE name = ?");
    $stmtCheck->execute([$name]);
    if ($stmtCheck->fetchColumn() > 0) {
        throw new Exception('La categoría "' . $name . '" ya existe.');
    }

    $sql = "INSERT INTO service_categories (name) VALUES (?)";
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute([$name])) {
        $last_id = $pdo->lastInsertId();
        $response = ['success' => true, 'message' => 'Categoría agregada con éxito.', 'id' => $last_id, 'name' => $name];
    } else {
        throw new Exception('Falló la ejecución de la consulta para agregar categoría.');
    }
} catch (PDOException $e) {
    error_log("PDO Error en categories-create.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => 'Error de Base de Datos: ' . $e->getMessage()];
} catch (Exception $e) {
    error_log("General Error en categories-create.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => $e->getMessage()];
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>