<?php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response = [];

try {
    $data = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Error: JSON inválido recibido.');
    }
    if (!isset($data['id'])) { // Usaremos el ID de la categoría para eliminar
        throw new Exception('El ID de la categoría es requerido para la eliminación.');
    }

    $id = (int)$data['id'];

    // Opcional: Podrías verificar si hay servicios asociados a esta categoría
    // y decidir si permites la eliminación o no. Por ahora, simplemente elimina.
    $sql = "DELETE FROM service_categories WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute([$id])) {
        if ($stmt->rowCount() > 0) {
            $response = ['success' => true, 'message' => 'Categoría eliminada con éxito.'];
        } else {
            throw new Exception('No se encontró la categoría para eliminar.');
        }
    } else {
        throw new Exception('Falló la ejecución de la consulta de eliminación.');
    }
} catch (PDOException $e) {
    error_log("PDO Error en categories-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => 'Error de Base de Datos: ' . $e->getMessage()];
} catch (Exception $e) {
    error_log("General Error en categories-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => $e->getMessage()];
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>