<?php
// db/user-profile-read.php
ob_start();
error_reporting(0); // Cambiar a E_ALL; ini_set('display_errors', 1); para depuración
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response_data = ['success' => false, 'data' => null];

try {
    // Asumimos que leeremos el perfil del usuario con ID 1 por simplicidad.
    // En un sistema real, el user_id vendría de la sesión del usuario autenticado.
    $user_id = 1; 

    $stmt = $pdo->prepare("SELECT full_name, email, profile_photo_url, plan_version, plan_renewal_date, next_invoice_date FROM user_profiles WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $profile = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($profile) {
        $response_data = ['success' => true, 'data' => $profile];
    } else {
        $response_data['message'] = 'No se encontró el perfil de usuario.';
    }

} catch (PDOException $e) {
    error_log("Error PDO al cargar perfil de usuario: " . $e->getMessage());
    $response_data['message'] = 'Error de Base de Datos al cargar perfil: ' . $e->getMessage();
} catch (Exception $e) {
    error_log("Error general al cargar perfil de usuario: " . $e->getMessage());
    $response_data['message'] = 'Error inesperado al cargar perfil: ' . $e->getMessage();
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response_data);
exit;
?>