<?php
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION['user_id'])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header('Location: login.php');
    exit();
}

// Incluye el archivo de conexión a la base de datos
require_once 'db/db_connection.php';

// Obtener los datos del usuario logueado
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT username, email, profile_photo FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    // Si por alguna razón no se encuentra el usuario, redirige a login
    session_destroy();
    header('Location: login.php');
    exit();
}

$username = htmlspecialchars($user['username']);
$user_email = htmlspecialchars($user['email']);
$profile_photo = htmlspecialchars($user['profile_photo'] ?? 'default_profile.png'); // Usa una imagen por defecto si no hay
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Local CRM</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css">
    <?php
    include 'files/GuardianKey.php';
    include 'files/GTM-Head.php';
    ?>
</head>
<body>
    <?php include 'files/GTM-Body.php'; ?>
    <div class="container">
        <aside class="sidebar">
            <div class="sidebar-header">
                <img src="img/logo.png" alt="Logo" class="logo">
                <p class="crm-title">Local CRM</p>
            </div>
            <nav class="sidebar-nav">
                <ul>
                    <li class="active"><a href="index.php"><i class="fas fa-home"></i> Inicio</a></li>
                    <li><a href="leads.php"><i class="fas fa-funnel-dollar"></i> Leads</a></li>
                    <li><a href="clients.php"><i class="fas fa-user-friends"></i> Clientes</a></li>
                    <li><a href="services.php"><i class="fas fa-briefcase"></i> Servicios</a></li>
                    <li><a href="agenda.php"><i class="fas fa-calendar-alt"></i> Agenda</a></li>
                    <li><a href="finances.php"><i class="fas fa-dollar-sign"></i> Finanzas</a></li>
                    <li><a href="quotes.php"><i class="fas fa-file-invoice-dollar"></i> Cotizaciones</a></li>
                    <li><a href="invoices.php"><i class="fas fa-receipt"></i> Facturas</a></li>
                    <li><a href="website.php"><i class="fas fa-globe"></i> Website</a></li>
                    <li><a href="promote.php"><i class="fas fa-bullhorn"></i> Promocionar</a></li>
                    <li><a href="ads.php"><i class="fas fa-ad"></i> Anuncios</a></li>
                    <li><a href="performance.php"><i class="fas fa-chart-line"></i> Rendimiento</a></li>
                    <li><a href="academy.php"><i class="fas fa-graduation-cap"></i> Academia</a></li>
                    <li><a href="account.php"><i class="fas fa-user-circle"></i> Cuenta</a></li>
                    <li><a href="login.php?logout=true"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a></li>
                </ul>
            </nav>
        </aside>

        <main class="main-content">
            <header class="navbar">
                <div class="menu-toggle">
                    <i class="fas fa-bars"></i>
                </div>
                <div class="navbar-left">
                    <h2>Inicio</h2>
                    <p id="currentDate"></p>
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
                            const today = new Date();
                            document.getElementById('currentDate').innerText = 'Hoy ' + today.toLocaleDateString('es-ES', options);
                        });
                    </script>
                </div>
                <div class="navbar-right">
                    <div class="notifications">
                        <i class="fas fa-bell"></i>
                        <span class="badge">3</span>
                    </div>
                    <div class="user-menu">
                        <img src="<?php echo $profile_photo; ?>" alt="Foto de perfil" class="profile-photo">
                        <span class="username"><?php echo $username; ?></span>
                        <i class="fas fa-chevron-down"></i>
                        <div class="dropdown-menu">
                            <a href="account.php">Mi Cuenta</a>
                            <a href="login.php?logout=true">Cerrar Sesión</a>
                        </div>
                    </div>
                </div>
            </header>

            <section class="dashboard">
                <div class="dashboard-cards" id="dashboardCards">
                    </div>

                <div class="quick-actions">
                    <h3>Acciones Rápidas</h3>
                    <div class="action-buttons">
                        <button onclick="window.location.href='clients.php'"> <i class="fas fa-user-plus"></i> Añadir Cliente</button>
                        <button onclick="window.location.href='leads.php'"><i class="fas fa-hand-holding-usd"></i> Nuevo Lead</button>
                        <button onclick="window.location.href='agenda.php'"><i class="fas fa-calendar-plus"></i> Agendar Cita</button>
                        <button onclick="window.location.href='invoices.php'"><i class="fas fa-file-invoice"></i> Crear Factura</button>
                    </div>
                </div>

                <div class="recent-activity">
                    <h3>Actividad Reciente</h3>
                    <ul id="activityList">
                        </ul>
                </div>

                <div class="ai-tools-overview">
                    <h3>Herramientas de IA</h3>
                    <div class="tool-categories">
                        <div class="tool-category">
                            <h4>Marketing y Publicidad</h4>
                            <ul>
                                <li><a href="ia-creador-de-publicaciones-sociales.php"><i class="fas fa-share-alt"></i> Creador de Publicaciones Sociales</a></li>
                                <li><a href="ia-generador-de-plan-tactico-publicitario.php"><i class="fas fa-lightbulb"></i> Generador de Plan Táctico Publicitario</a></li>
                                <li><a href="tools/ia-generador-de-anuncios-publicitarios.php"><i class="fas fa-ad"></i> Generador de Anuncios Publicitarios</a></li>
                                <li><a href="tools/Tool-Analista-De-Resultados-Publicitarios.php"><i class="fas fa-chart-bar"></i> Analista de Resultados Publicitarios</a></li>
                                <li><a href="tools/Tool-Asistente-De-Ofertas-Y-Promociones.php"><i class="fas fa-tags"></i> Asistente de Ofertas y Promociones</a></li>
                                <li><a href="tools/Tool-Generador-De-Titulos-Para-Imagenes.php"><i class="fas fa-image"></i> Generador de Títulos para Imágenes</a></li>
                            </ul>
                        </div>
                        <div class="tool-category">
                            <h4>Ventas y Comunicación</h4>
                            <ul>
                                <li><a href="ia-generador-de-mensaje-primer-contacto.php"><i class="fas fa-envelope"></i> Generador de Mensaje Primer Contacto</a></li>
                                <li><a href="ia-asistente-de-seguimiento-estrategico.php"><i class="fas fa-comments"></i> Asistente de Seguimiento Estratégico</a></li>
                                <li><a href="ia-creador-de-propuestas-de-proyectos.php"><i class="fas fa-file-alt"></i> Creador de Propuestas de Proyectos</a></li>
                                <li><a href="tools/ia-asistente-inteligente-de-ventas.php"><i class="fas fa-headset"></i> Asistente Inteligente de Ventas</a></li>
                                <li><a href="tools/Tool-Generador-De-Respuestas-Messenger.php"><i class="fab fa-facebook-messenger"></i> Generador de Respuestas para Messenger</a></li>
                                <li><a href="tools/Tool-Generador-De-Respuestas-Para-Grupos.php"><i class="fas fa-users"></i> Generador de Respuestas para Grupos</a></li>
                                <li><a href="tools/Tool-Creador-De-Respuestas-A-Resenas.php"><i class="fas fa-star"></i> Creador de Respuestas a Reseñas</a></li>
                                <li><a href="tools/Tool-Optimizador-De-WhatsApp-Business.php"><i class="fab fa-whatsapp"></i> Optimizador de WhatsApp Business</a></li>
                            </ul>
                        </div>
                        <div class="tool-category">
                            <h4>Estrategia y Gestión</h4>
                            <ul>
                                <li><a href="ia-traductor-ingles-inteligente.php"><i class="fas fa-language"></i> Traductor Inglés Inteligente</a></li>
                                <li><a href="tools/Tool-Generador-De-Cliente-Ideal.php"><i class="fas fa-user-check"></i> Generador de Cliente Ideal</a></li>
                                <li><a href="tools/Tool-Mini-Test-De-Diagnostico.php"><i class="fas fa-diagnoses"></i> Mini Test de Diagnóstico</a></li>
                                <li><a href="tools/Tool-Planificador-De-Objetivos.php"><i class="fas fa-crosshairs"></i> Planificador de Objetivos</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>
        </main>
    </div>

    <?php include 'files/footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/locales-all.min.js"></script>
    <script src="files/header-manager.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Fetch Dashboard Cards
            fetch('db/dashboard-read.php')
                .then(response => response.json())
                .then(data => {
                    const dashboardCards = document.getElementById('dashboardCards');
                    if (data.success) {
                        const cardsHtml = `
                            <div class="card">
                                <h4>Leads Totales</h4>
                                <p>${data.totalLeads}</p>
                            </div>
                            <div class="card">
                                <h4>Clientes Activos</h4>
                                <p>${data.activeClients}</p>
                            </div>
                            <div class="card">
                                <h4>Facturas Pendientes</h4>
                                <p>$${data.pendingInvoices}</p>
                            </div>
                            <div class="card">
                                <h4>Ingresos Este Mes</h4>
                                <p>$${data.monthlyRevenue}</p>
                            </div>
                        `;
                        dashboardCards.innerHTML = cardsHtml;
                    } else {
                        dashboardCards.innerHTML = '<p>Error al cargar los datos del dashboard.</p>';
                    }
                })
                .catch(error => {
                    console.error('Error fetching dashboard data:', error);
                    document.getElementById('dashboardCards').innerHTML = '<p>Error de conexión al cargar el dashboard.</p>';
                });

            // Fetch Recent Activity (Example, adjust API as needed)
            // For now, using static data or you can create a db/activity-read.php
            const activityList = document.getElementById('activityList');
            const staticActivity = [
                "Nuevo cliente registrado: Juan Pérez",
                "Cita agendada con María García para el 15 de Julio",
                "Factura #2023001 pagada por Empresa XYZ",
                "Lead 'Proyecto Alpha' actualizado a 'Contacto Hecho'"
            ];
            staticActivity.forEach(activity => {
                const li = document.createElement('li');
                li.textContent = activity;
                activityList.appendChild(li);
            });
        });
    </script>
</body>
</html>