<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión | LocalCRM ToolKit</title>
        <meta name="description" content="Gestiona tus prospectos y potenciales clientes con el LocalCRM ToolKit Dashboard de OrozDesign Multimedia.">
    <meta name="robots" content="noindex, nofollow">

    <link rel="icon" type="image/png" href="img/favicon.png">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.png">

    <?php include 'files/gtm-head.php'; ?>

    <!-- Enlace a Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Enlace a la fuente Barlow de Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Enlace a Lucide Icons para los iconos -->
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css">
    <style>
        /* Paleta de colores de la marca */
        :root {
            --color-primary: #07162d; /* Azul Oscuro */
            --color-secondary: #9e1428; /* Rojo */
            --color-highlight: #ffc857; /* Amarillo */
            --color-background: #f5f5f5; /* Fondo Blanco */
        }

        body {
            font-family: 'Barlow', sans-serif;
            /* Aplicamos el gradiente al body para que cubra toda la pantalla */
            background: linear-gradient(135deg, var(--color-primary) 0%, #1a2b42 100%);
            display: flex;
            flex-direction: column; /* Permite centrar verticalmente y añadir el copyright abajo */
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 1rem; /* Espaciado general para móviles */
            box-sizing: border-box; /* Asegura que el padding no cause desbordamiento */
        }

        /* Estilos para el título de dos colores */
        .main-title-part-1 { color: var(--color-primary); }
        .main-title-part-2 { color: var(--color-secondary); }

        /* Estilo para el botón secundario (Iniciar Sesión) */
        .btn-secondary {
            background-color: var(--color-secondary);
            color: white;
            transition: all 0.3s ease;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .btn-secondary:hover {
            background-color: #7c1020; /* Tono más oscuro al pasar el ratón */
            transform: translateY(-2px); /* Efecto de "levantar" */
            box-shadow: 0 10px 15px -3px rgba(158, 20, 40, 0.3), 0 4px 6px -2px rgba(158, 20, 40, 0.1);
        }
        .btn-secondary:active {
            transform: translateY(-1px) scale(0.98); /* Efecto de "presionar" */
            box-shadow: 0 2px 4px -1px rgba(158, 20, 40, 0.2);
        }

        /* Estilo para los campos de entrada con icono */
        .input-with-icon {
            position: relative;
        }
        .input-with-icon input {
            padding-left: 2.5rem; /* Espacio para el icono */
        }
        .input-with-icon .icon {
            position: absolute;
            left: 0.75rem; /* 12px */
            top: 50%;
            transform: translateY(-50%);
            color: #9ca3af; /* gray-400 */
            pointer-events: none; /* Asegura que el icono no bloquee el clic en el input */
        }

        /* Estilo para el checkbox de "Recordarme" */
        input[type="checkbox"] {
            accent-color: var(--color-primary); /* Cambia el color del checkbox nativo */
        }

        /* Overlay para la imagen del lado derecho */
        .image-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(7, 22, 45, 0.6) 0%, rgba(158, 20, 40, 0.4) 100%);
            border-radius: 0 1rem 1rem 0; /* Solo esquinas derechas redondeadas */
        }

        /* Media queries para ajustar el diseño en pantallas pequeñas */
        @media (max-width: 767px) {
            .login-card {
                padding: 1.5rem; /* Menos padding en móviles */
            }
            /* Ajuste el tamaño del título para móviles */
            .title-mobile-adjust {
                font-size: 2.5rem; /* Tamaño de fuente más pequeño para el título en móvil */
            }
        }
    </style>
</head>
<body class="flex flex-col items-center justify-center min-h-screen p-4">
<?php include 'files/gtm-body.php'; ?>

    <div class="w-full max-w-4xl">
        <!-- Logotipo -->
        <div class="mb-6 text-center">
            <!-- Usamos el onerror para un fallback visual si la imagen no carga -->
            <img src="img/LogoPlataformaBlanco.png" alt="Logotipo" class="w-48 mx-auto" onerror="this.src='https://placehold.co/192x64/07162d/ffffff?text=OrozDesign'; this.style.backgroundColor='transparent';">
        </div>

        <!-- Contenedor del Login -->
        <div class="relative flex flex-col bg-white shadow-2xl rounded-2xl md:flex-row md:space-y-0 overflow-hidden">
            <!-- Lado Izquierdo (Formulario) -->
            <div class="flex flex-col justify-center p-6 md:p-10 w-full md:w-1/2">
                <h2 class="mb-2 text-4xl font-extrabold text-center md:text-left title-mobile-adjust">
                    <span class="main-title-part-1">BIENVENIDO </span><span class="main-title-part-2">DE NUEVO</span>
                </h2>
                <span class="font-light text-gray-500 text-base mb-4 text-center md:text-left"> <!-- Reducido mb-6 a mb-4 -->
                    Ingresa A Tu Panel Para Gestionar Tu Negocio.
                </span>

                <!-- Área para mensajes de error (oculta por defecto) -->
                <div id="error-message" class="hidden bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                    <strong class="font-bold">¡Error!</strong>
                    <span class="block sm:inline" id="error-text"></span>
                </div>

                <form action="dashboard.php" method="POST" class="space-y-3"> <!-- Reducido space-y-4 a space-y-3 -->
                    <div> <!-- Eliminado py-2 -->
                        <label for="email" class="block mb-1 text-md font-semibold text-gray-700 text-left">Correo Electrónico</label> <!-- Reducido mb-2 a mb-1 -->
                        <div class="input-with-icon">
                            <i data-lucide="mail" class="icon w-5 h-5"></i>
                            <input 
                                type="email"
                                id="email"
                                name="email"
                                class="w-full p-3 border border-gray-300 rounded-lg placeholder:font-light placeholder:text-gray-400 focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]"
                                placeholder="tu@email.com"
                                required
                                autocomplete="email"
                            >
                        </div>
                    </div>
                    <div> <!-- Eliminado py-2 -->
                        <label for="password" class="block mb-1 text-md font-semibold text-gray-700 text-left">Contraseña</label> <!-- Reducido mb-2 a mb-1 -->
                        <div class="input-with-icon">
                            <i data-lucide="key" class="icon w-5 h-5"></i>
                            <input 
                                type="password"
                                id="password"
                                name="password"
                                class="w-full p-3 border border-gray-300 rounded-lg placeholder:font-light placeholder:text-gray-400 focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]"
                                placeholder="Ingresa tu contraseña"
                                required
                                autocomplete="current-password"
                            >
                        </div>
                    </div>

                    <div class="flex justify-between w-full py-2 items-center"> <!-- Reducido py-3 a py-2 -->
                        <div class="flex items-center">
                            <input type="checkbox" name="remember" id="remember" class="mr-2 h-4 w-4 rounded border-gray-300 text-[var(--color-primary)] focus:ring-[var(--color-primary)]">
                            <label for="remember" class="text-md font-black text-gray-700">RECORDARME</label>
                        </div>
                        <a href="#" class="font-bold text-md text-[var(--color-secondary)] hover:underline">¿OLVIDASTE TU CONTRASEÑA?</a>
                    </div>

                    <button type="submit" class="w-full btn-secondary font-bold p-3 rounded-lg mb-6 flex items-center justify-center uppercase">
                        <i data-lucide="log-in" class="w-5 h-5 mr-2"></i>
                        <span>Iniciar Sesión</span>
                    </button>
                </form>

                <div class="text-center text-gray-500">
                    ¿NO TIENES UNA CUENTA?
                    <a href="#" class="font-bold text-[var(--color-secondary)] hover:underline">REGÍSTRATE AQUÍ</a>
                </div>
            </div>

            <!-- Lado Derecho (Imagen y Marca con Overlay) -->
            <div class="relative hidden md:block md:w-1/2">
                <img 
                    src="img/Portada.jpg" 
                    alt="Imagen de fondo para el login" 
                    class="w-full h-full object-cover rounded-r-2xl"
                >
                <!-- Overlay para la imagen -->
                <div class="image-overlay"></div>
            </div>
        </div>
        
        <!-- Copyright -->
        <?php include 'files/footer.php'; ?>
    </div>

    <script>
        // Inicializa los iconos de Lucide al cargar la página
        lucide.createIcons();

        // Función para mostrar mensajes de error (ejemplo, se integraría con tu backend)
        function showErrorMessage(message) {
            const errorMessageDiv = document.getElementById('error-message');
            const errorTextSpan = document.getElementById('error-text');
            errorTextSpan.textContent = message;
            errorMessageDiv.classList.remove('hidden');
        }

        // Ejemplo de uso (puedes llamar a esto desde tu script de autenticación PHP/JS)
        // showErrorMessage('Credenciales incorrectas. Inténtalo de nuevo.');
    </script>
</body>
</html>
