<?php include 'files/guardiankey.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit Dashboard | Rendimiento | OrozDesign Multimedia</title>
    <meta name="description" content="Analiza el rendimiento de tu negocio con LocalCRM: visualiza métricas, gráficos y reportes para tomar decisiones informadas y optimizar tus resultados">
    <meta name="robots" content="noindex, nofollow">

    <link rel="icon" type="image/png" href="img/favicon.png">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.png">

    <?php include 'files/gtm-head.php'; ?>

    <script src="https://cdn.tailwindcss.com"></script>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <link rel="stylesheet" href="style.css">
    <script src="files/header-manager.js"></script>
    <style>
        /* Agregamos las reglas CSS para tablas responsivas que ya hemos usado */
        @media (max-width: 767px) {
            .responsive-table-stack tbody,
            .responsive-table-stack tr,
            .responsive-table-stack td {
                display: block;
                width: 100%;
            }

            .responsive-table-stack thead {
                display: none; /* Oculta el encabezado de la tabla original */
            }

            .responsive-table-stack tr {
                margin-bottom: 1rem; /* Espacio entre las "tarjetas" de fila */
                border: 1px solid #e2e8f0;
                border-radius: 0.5rem;
                padding: 0.5rem;
                background-color: white;
                box-shadow: 0 1px 3px 0 rgb(0 0 0 / 0.1), 0 1px 2px -1px rgb(0 0 0 / 0.1);
            }

            .responsive-table-stack td {
                text-align: right !important; /* Alinea el valor a la derecha */
                padding-left: 50% !important; /* Deja espacio para la etiqueta */
                position: relative;
                border-bottom: 1px solid #edf2f7; /* Separador entre campos */
                padding-top: 0.75rem;
                padding-bottom: 0.75rem;
                white-space: normal; /* Permite que el texto se ajuste */
                word-break: break-word; /* Rompe palabras largas */
            }

            .responsive-table-stack td:last-child {
                border-bottom: 0; /* No hay borde inferior en el último campo */
            }

            /* Etiqueta del campo (header) */
            .responsive-table-stack td::before {
                content: attr(data-label); /* Usa el atributo data-label como contenido */
                position: absolute;
                left: 0.75rem;
                width: calc(50% - 1.5rem); /* Ocupa la mitad izquierda */
                padding-right: 1rem;
                white-space: nowrap; /* Evita que la etiqueta se rompa */
                text-align: left;
                font-weight: bold;
                text-transform: uppercase;
                color: #4a5568;
                flex-shrink: 0;
            }

            /* Ajustes para celdas de acciones/botones (si se aplican) */
            .responsive-table-stack td.actions-cell {
                text-align: center !important;
                padding-left: 0 !important;
                display: flex;
                flex-direction: column; /* Apila los botones verticalmente */
                justify-content: center;
                align-items: center;
                gap: 0.75rem; /* Espacio entre botones */
                min-height: 48px; /* Altura mínima para la fila de botones */
                flex-wrap: wrap; /* Permite que los botones se envuelvan si hay muchos */
            }

            .responsive-table-stack td.actions-cell::before {
                content: none; /* No mostrar etiqueta para celdas de acciones */
            }

            .responsive-table-stack td.actions-cell button {
                width: 100%; /* Toma todo el ancho disponible */
                flex-grow: 0;
                min-width: 80px;
            }
        }
    </style>
</head>
<body data-page-title="RENDIMIENTO DEL NEGOCIO"
      data-page-subtitle="ANÁLISIS MENSUAL DE MÉTRICAS CLAVE"
      data-page-icon="trending-up">
    
    <div id="toast-container" class="toast-container"></div>
        
    <?php include 'files/gtm-body.php'; ?>

<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8 space-y-8">
            <section id="rendimiento" class="dashboard-section">
                <div class="mb-6">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
                        <div>
                            <h3 class="text-2xl font-extrabold text-gray-800 flex items-center gap-2">
                                <i data-lucide="bar-chart-2" class="w-7 h-7 text-[var(--color-primary)]"></i> VISTA GENERAL DE RENDIMIENTO
                            </h3>
                            <p class="text-gray-500 text-sm mt-1 uppercase">ANÁLISIS GLOBAL DE LAS MÉTRICAS DE TU NEGOCIO.</p>
                        </div>
                        <div class="flex items-center gap-3">
                            <label for="month-select" class="text-gray-600 font-semibold">Seleccionar Mes:</label>
                            <select id="month-select" class="p-2 border border-gray-300 rounded-md focus:ring-[var(--color-primary)] focus:border-[var(--color-primary)]">
                            </select>
                        </div>
                    </div>
                </div>

               <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mt-8">
    <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-primary)]">
        <i data-lucide="user-plus" class="w-12 h-12 text-gray-700"></i>
        <div>
            <h3 class="text-lg font-extrabold text-gray-500 mb-1 uppercase">PROSPECTOS ADQUIRIDOS</h3>
            <p id="stat-leads" class="text-5xl font-bold text-[var(--color-secondary)] uppercase">0</p>
            <p class="text-sm text-gray-400 mt-1 uppercase">En el mes</p>
        </div>
    </div>

    <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-secondary)]">
        <i data-lucide="users" class="w-12 h-12 text-gray-700"></i>
        <div>
            <h3 class="text-lg font-extrabold text-gray-500 mb-1 uppercase">CLIENTES CONVERTIDOS</h3>
            <p id="stat-clientes" class="text-5xl font-bold text-[var(--color-secondary)] uppercase">0</p>
            <p class="text-sm text-gray-400 mt-1 uppercase">En el mes</p>
        </div>
    </div>

    <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-highlight)]">
        <i data-lucide="package" class="w-12 h-12 text-gray-700"></i>
        <div>
            <h3 class="text-lg font-extrabold text-gray-500 mb-1 uppercase">SERVICIOS VENDIDOS</h3>
            <p id="stat-servicios" class="text-5xl font-bold text-[var(--color-secondary)] uppercase">0</p>
            <p class="text-sm text-gray-400 mt-1 uppercase">En el mes</p>
        </div>
    </div>

    <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-highlight)]">
        <i data-lucide="wallet" class="w-12 h-12 text-gray-700"></i>
        <div>
            <h3 class="text-lg font-extrabold text-gray-500 mb-1 uppercase">FACTURACIÓN MENSUAL</h3>
            <p id="stat-facturacion" class="text-5xl font-bold text-[var(--color-secondary)] uppercase">$0</p>
            <p class="text-sm text-gray-400 mt-1 uppercase">En el mes</p>
        </div>
    </div>

    <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-primary)]">
        <i data-lucide="file-text" class="w-12 h-12 text-gray-700"></i>
        <div>
            <h3 class="text-lg font-extrabold text-gray-500 mb-1 uppercase">COTIZACIONES GENERADAS</h3>
            <p id="stat-cotizaciones" class="text-5xl font-bold text-[var(--color-secondary)] uppercase">0</p>
            <p class="text-sm text-gray-400 mt-1 uppercase">En el mes</p>
        </div>
    </div>

    <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-secondary)]">
        <i data-lucide="receipt" class="w-12 h-12 text-gray-700"></i>
        <div>
            <h3 class="text-lg font-extrabold text-gray-500 mb-1 uppercase">FACTURAS PAGADAS</h3>
            <p id="stat-facturas" class="text-5xl font-bold text-[var(--color-secondary)] uppercase">0</p>
            <p class="text-sm text-gray-400 mt-1 uppercase">En el mes</p>
        </div>
    </div>

    <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-highlight)]">
        <i data-lucide="calendar-plus" class="w-12 h-12 text-gray-700"></i>
        <div>
            <h3 class="text-lg font-extrabold text-gray-500 mb-1 uppercase">CITAS NUEVAS</h3>
            <p id="stat-citas-nuevas" class="text-5xl font-bold text-[var(--color-secondary)] uppercase">0</p>
            <p class="text-sm text-gray-400 mt-1 uppercase">En el mes</p>
        </div>
    </div>

    <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-secondary)]">
        <i data-lucide="repeat" class="w-12 h-12 text-gray-700"></i>
        <div>
            <h3 class="text-lg font-extrabold text-gray-500 mb-1 uppercase">CITAS RECURRENTES</h3>
            <p id="stat-citas-recurrentes" class="text-5xl font-bold text-[var(--color-secondary)] uppercase">0</p>
            <p class="text-sm text-gray-400 mt-1 uppercase">En el mes</p>
        </div>
    </div>
</div>

                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mt-8">
                    <div class="bg-white p-6 rounded-xl shadow-md">
                        <h3 class="text-xl font-extrabold text-gray-800 mb-4 flex items-center gap-2">
                            <i data-lucide="trending-up" class="w-6 h-6 text-[var(--color-secondary)]"></i> FACTURACIÓN Y SERVICIOS (MENSUAL)
                        </h3>
                        <div class="h-80">
                            <canvas id="facturacionServiciosChart"></canvas>
                        </div>
                    </div>
                    <div class="bg-white p-6 rounded-xl shadow-md">
                        <h3 class="text-xl font-extrabold text-gray-800 mb-4 flex items-center gap-2">
                            <i data-lucide="pie-chart" class="w-6 h-6 text-[var(--color-secondary)]"></i> PROSPECTOS VS. CLIENTES CONVERTIDOS (MENSUAL)
                        </h3>
                        <div class="h-80">
                            <canvas id="leadsClientsChart"></canvas>
                        </div>
                    </div>
                    <div class="bg-white p-6 rounded-xl shadow-md lg:col-span-2">
                        <h3 class="text-xl font-extrabold text-gray-800 mb-4 flex items-center gap-2">
                            <i data-lucide="calendar" class="w-6 h-6 text-[var(--color-secondary)]"></i> CITAS NUEVAS VS. RECURRENTES (MENSUAL)
                        </h3>
                        <div class="h-80">
                            <canvas id="citasChart"></canvas>
                        </div>
                    </div>
                </div>

                <div class="bg-white p-6 rounded-xl shadow-md mt-8">
                    <h3 class="text-xl font-extrabold text-gray-800 mb-4 flex items-center gap-2">
                        <i data-lucide="list-checks" class="w-6 h-6 text-[var(--color-success)]"></i> DESGLOSE DE RENDIMIENTO POR MES
                    </h3>
                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white responsive-table-stack">
                            <thead>
                                <tr class="bg-gray-100 text-gray-600 uppercase text-sm leading-normal">
                                    <th class="py-3 px-6 text-left">Mes</th>
                                    <th class="py-3 px-6 text-left">Leads</th>
                                    <th class="py-3 px-6 text-left">Clientes</th>
                                    <th class="py-3 px-6 text-left">Servicios</th>
                                    <th class="py-3 px-6 text-left">Facturación</th>
                                    <th class="py-3 px-6 text-left">Cotizaciones</th>
                                    <th class="py-3 px-6 text-left">Facturas</th>
                                    <th class="py-3 px-6 text-left">Citas Nuevas</th>
                                    <th class="py-3 px-6 text-left">Citas Recurrentes</th>
                                </tr>
                            </thead>
                            <tbody id="performance-table-body" class="text-gray-600 text-sm font-light">
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>

<script>
    // ** Datos de ejemplo para el dashboard de rendimiento **
    // En un entorno real, esta data provendría de tu base de datos a través de PHP.
    let APP_DATA = { // Cambiado de const a let para poder ser reasignado
        rendimientoMensual: {
            // Se asume que estos datos serán reemplazados por los de 'db/performance-read.php'
            // Ejemplo de estructura de datos (para referencia):
            // "2024-01": { leads: 100, clientes: 20, serviciosVendidos: 30, facturacion: 15000, cotizacionesGeneradas: 50, facturasPagadas: 25, citasNuevas: 15, citasRecurrentes: 5 },
            // "2024-02": { leads: 120, clientes: 25, serviciosVendidos: 35, facturacion: 18000, cotizacionesGeneradas: 60, facturasPagadas: 30, citasNuevas: 18, citasRecurrentes: 7 },
            // ...
        }
    };

    document.addEventListener('DOMContentLoaded', function() {
        // Referencias a elementos DOM comunes (menú lateral)
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar'); // Asegúrate de que este ID exista en tu 'menu.php'
        const sidebarOverlay = document.getElementById('sidebar-overlay');
        
        // Referencia al selector de mes
        const monthSelect = document.getElementById('month-select');

        // Referencias a los elementos de las tarjetas de estadísticas
        const statLeads = document.getElementById('stat-leads');
        const statClientes = document.getElementById('stat-clientes');
        const statServicios = document.getElementById('stat-servicios');
        const statFacturacion = document.getElementById('stat-facturacion');
        const statCotizaciones = document.getElementById('stat-cotizaciones');
        const statFacturas = document.getElementById('stat-facturas');
        const statCitasNuevas = document.getElementById('stat-citas-nuevas');
        const statCitasRecurrentes = document.getElementById('stat-citas-recurrentes');
        
        // Referencia al cuerpo de la tabla de rendimiento
        const performanceTableBody = document.getElementById('performance-table-body');

        // Instancias de los gráficos para poder destruirlos y volver a renderizarlos
        let facturacionServiciosChartInstance;
        let leadsClientsChartInstance;
        let citasChartInstance;

        // Función para mostrar mensajes de tostada (toast notifications)
        // Asegúrate de tener una implementación de `showToast` en `files/header-manager.js` o en este script.
        // Si no existe, puedes añadir una función simple como esta:
        function showToast(message, type = 'info', duration = 3000) {
            const toastContainer = document.getElementById('toast-container');
            if (!toastContainer) {
                console.warn('Toast container not found. Message:', message);
                return;
            }

            const toast = document.createElement('div');
            toast.className = `toast toast-${type} p-3 rounded shadow-md text-white mb-2`;
            toast.textContent = message;

            // Estilos básicos para las tostadas (puedes personalizarlos con Tailwind)
            const typeColors = {
                'info': 'bg-blue-500',
                'success': 'bg-green-500',
                'error': 'bg-red-500',
                'warning': 'bg-orange-500'
            };
            toast.classList.add(typeColors[type] || typeColors.info);

            toastContainer.appendChild(toast);

            setTimeout(() => {
                toast.remove();
            }, duration);
        }

        // Función para obtener los valores de las variables CSS (colores de tu style.css)
        const getCssVar = (name) => {
            try {
                const value = getComputedStyle(document.documentElement).getPropertyValue(name).trim();
                if (!value || value === 'initial' || value === 'unset' || value === 'revert' || value === 'inherit') {
                    throw new Error(`Variable CSS '${name}' no definida o inválida.`);
                }
                return value;
            } catch (e) {
                showToast(`Error al obtener la variable CSS ${name}. Usando valor por defecto.`, 'warning');
                // Devuelve un color por defecto basado en tu branding o un color genérico si la variable no se encuentra
                if (name === '--color-primary') return '#07162d';
                if (name === '--color-secondary') return '#9e1428';
                if (name === '--color-highlight') return '#ffc857';
                if (name === '--color-success') return '#10B981';
                if (name === '--color-warning') return '#F59E0B';
                return '#CCCCCC'; // Default fallback genérico
            }
        };

        // Obtener los colores al inicio
        const primaryColor = getCssVar('--color-primary');
        const secondaryColor = getCssVar('--color-secondary');
        const highlightColor = getCssVar('--color-highlight');
        const successColor = getCssVar('--color-success');
        const warningColor = getCssVar('--color-warning');

        // Función para generar dinámicamente las opciones del selector de mes
        function populateMonthSelect() {
            // Obtener todas las claves de meses del objeto rendimientoMensual y ordenarlas
            const months = Object.keys(APP_DATA.rendimientoMensual).sort((a, b) => {
                // Ordenar por año y luego por mes para asegurar un orden cronológico correcto
                const [yearA, monthA] = a.split('-').map(Number);
                const [yearB, monthB] = b.split('-').map(Number);
                if (yearA !== yearB) return yearA - yearB;
                return monthA - monthB;
            });
            
            // Nombres de los meses abreviados para mostrar en el selector
            const monthNames = {
                '01': 'Ene', '02': 'Feb', '03': 'Mar', '04': 'Abr', '05': 'May', '06': 'Jun',
                '07': 'Jul', '08': 'Ago', '09': 'Sep', '10': 'Oct', '11': 'Nov', '12': 'Dic'
            };

            // Limpiar opciones existentes
            monthSelect.innerHTML = ''; 

            // Crear y añadir cada opción al selector
            if (months.length === 0) {
                const option = document.createElement('option');
                option.value = '';
                option.textContent = 'NO HAY DATOS DISPONIBLES'; // Changed to ALL CAPS
                monthSelect.appendChild(option);
                monthSelect.disabled = true; // Deshabilitar si no hay datos
            } else {
                monthSelect.disabled = false;
                months.forEach(monthKey => {
                    const [year, monthNum] = monthKey.split('-');
                    const option = document.createElement('option');
                    option.value = monthKey; // El valor será 'YYYY-MM'
                    option.textContent = `${monthNames[monthNum].toUpperCase()} ${year}`; // Changed to ALL CAPS
                    monthSelect.appendChild(option);
                });

                // Establecer el mes actual como valor por defecto si existe, de lo contrario, el último mes disponible
                const today = new Date();
                const currentYearMonth = `${today.getFullYear()}-${String(today.getMonth() + 1).padStart(2, '0')}`;
                if (APP_DATA.rendimientoMensual[currentYearMonth]) {
                    monthSelect.value = currentYearMonth;
                } else {
                    monthSelect.value = months[months.length - 1]; // Si el mes actual no está, selecciona el último disponible
                }
            }
        }

        // Función para actualizar los valores en las tarjetas de estadísticas
        function updateStatCards(monthKey) {
            const data = APP_DATA.rendimientoMensual[monthKey] || {};
            
            statLeads.textContent = data.leads !== undefined ? data.leads : 0;
            statClientes.textContent = data.clientes !== undefined ? data.clientes : 0;
            statServicios.textContent = data.serviciosVendidos !== undefined ? data.serviciosVendidos : 0;
            statFacturacion.textContent = `$${(data.facturacion !== undefined ? data.facturacion : 0).toLocaleString('es-US')}`;
            statCotizaciones.textContent = data.cotizacionesGeneradas !== undefined ? data.cotizacionesGeneradas : 0;
            statFacturas.textContent = data.facturasPagadas !== undefined ? data.facturasPagadas : 0;
            statCitasNuevas.textContent = data.citasNuevas !== undefined ? data.citasNuevas : 0;
            statCitasRecurrentes.textContent = data.citasRecurrentes !== undefined ? data.citasRecurrentes : 0;
            
            lucide.createIcons(); // Vuelve a renderizar los íconos de Lucide
        }

        // Función para renderizar el gráfico de Facturación y Servicios Vendidos
        function renderFacturacionServiciosChart() {
            const ctx = document.getElementById('facturacionServiciosChart')?.getContext('2d');
            if (ctx) {
                // Destruir la instancia anterior del gráfico si existe para evitar duplicados
                if (facturacionServiciosChartInstance) { facturacionServiciosChartInstance.destroy(); }

                // Preparar los datos para el gráfico de línea
                const labels = Object.keys(APP_DATA.rendimientoMensual).sort((a, b) => {
                    const [yearA, monthA] = a.split('-').map(Number);
                    const [yearB, monthB] = b.split('-').map(Number);
                    if (yearA !== yearB) return yearA - yearB;
                    return monthA - monthB;
                });
                const facturacionData = labels.map(month => APP_DATA.rendimientoMensual[month].facturacion);
                const serviciosData = labels.map(month => APP_DATA.rendimientoMensual[month].serviciosVendidos);

                // Crear el nuevo gráfico
                facturacionServiciosChartInstance = new Chart(ctx, {
                    type: 'line', // Tipo de gráfico: línea
                    data: {
                        labels: labels.map(key => {
                            const [year, monthNum] = key.split('-');
                            return new Date(year, monthNum - 1, 1).toLocaleDateString('es-US', { month: 'short', year: '2-digit' });
                        }),
                        datasets: [{
                            label: 'Facturación',
                            data: facturacionData,
                            borderColor: primaryColor, // Usando primaryColor para Facturación
                            backgroundColor: primaryColor + '20', // Color con opacidad para el área rellena
                            fill: true,
                            tension: 0.3 // Curvatura de la línea
                        }, {
                            label: 'Servicios Vendidos',
                            data: serviciosData,
                            borderColor: secondaryColor, // Usando secondaryColor para Servicios Vendidos
                            backgroundColor: secondaryColor + '20',
                            fill: true,
                            tension: 0.3,
                            yAxisID: 'y1' // Asignar a un segundo eje Y
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false, // Permite que el gráfico no mantenga su proporción original
                        interaction: {
                            mode: 'index',
                            intersect: false,
                        },
                        scales: {
                            y: { // Primer eje Y (izquierda) para Facturación
                                beginAtZero: true,
                                type: 'linear',
                                display: true,
                                position: 'left',
                                ticks: {
                                    callback: value => '$' + value.toLocaleString('es-US') // Formato de dinero
                                }
                            },
                            y1: { // Segundo eje Y (derecha) para Servicios Vendidos
                                beginAtZero: true,
                                type: 'linear',
                                display: true,
                                position: 'right',
                                grid: {
                                    drawOnChartArea: false, // Evita dibujar las líneas de la cuadrícula en el área del gráfico
                                }
                            }
                        },
                        plugins: {
                            legend: { position: 'top' }, // Posición de la leyenda
                            tooltip: { // Configuración de los tooltips al pasar el ratón
                                callbacks: {
                                    label: context => {
                                        let label = context.dataset.label || '';
                                        if (label) { label += ': '; }
                                        if (context.dataset.label === 'Facturación') {
                                            label += new Intl.NumberFormat('es-US', { style: 'currency', currency: 'USD' }).format(context.parsed.y);
                                        } else {
                                            label += context.parsed.y;
                                        }
                                        return label;
                                    }
                                }
                            }
                        }
                    }
                });
            }
        }

        // Función para renderizar el gráfico de Leads vs. Clientes Convertidos
        function renderLeadsClientsChart() {
            const ctx = document.getElementById('leadsClientsChart')?.getContext('2d');
            if (ctx) {
                if (leadsClientsChartInstance) { leadsClientsChartInstance.destroy(); }

                const labels = Object.keys(APP_DATA.rendimientoMensual).sort((a, b) => {
                    const [yearA, monthA] = a.split('-').map(Number);
                    const [yearB, monthB] = b.split('-').map(Number);
                    if (yearA !== yearB) return yearA - yearB;
                    return monthA - monthB;
                });
                const leadsData = labels.map(month => APP_DATA.rendimientoMensual[month].leads);
                const clientsData = labels.map(month => APP_DATA.rendimientoMensual[month].clientes);

                leadsClientsChartInstance = new Chart(ctx, {
                    type: 'bar', // Tipo de gráfico: barras
                    data: {
                        labels: labels.map(key => {
                            const [year, monthNum] = key.split('-');
                            return new Date(year, monthNum - 1, 1).toLocaleDateString('es-US', { month: 'short', year: '2-digit' });
                        }),
                        datasets: [{
                            label: 'Leads',
                            data: leadsData,
                            backgroundColor: primaryColor, // Usando primaryColor para Leads
                            borderRadius: 5,
                        }, {
                            label: 'Clientes Convertidos',
                            data: clientsData,
                            backgroundColor: secondaryColor, // Usando secondaryColor para Clientes Convertidos
                            borderRadius: 5,
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: {
                            y: { beginAtZero: true, }
                        },
                        plugins: {
                            legend: { position: 'top' },
                        }
                    }
                });
            }
        }

        // Función para renderizar el gráfico de Citas Nuevas vs. Recurrentes
        function renderCitasChart() {
            const ctx = document.getElementById('citasChart')?.getContext('2d');
            if (ctx) {
                if (citasChartInstance) { citasChartInstance.destroy(); }

                const labels = Object.keys(APP_DATA.rendimientoMensual).sort((a, b) => {
                    const [yearA, monthA] = a.split('-').map(Number);
                    const [yearB, monthB] = b.split('-').map(Number);
                    if (yearA !== yearB) return yearA - yearB;
                    return monthA - monthB;
                });
                const citasNuevasData = labels.map(month => APP_DATA.rendimientoMensual[month].citasNuevas);
                const citasRecurrentesData = labels.map(month => APP_DATA.rendimientoMensual[month].citasRecurrentes);

                citasChartInstance = new Chart(ctx, {
                    type: 'bar', // Puedes cambiar a 'line' si prefieres líneas
                    data: {
                        labels: labels.map(key => {
                            const [year, monthNum] = key.split('-');
                            return new Date(year, monthNum - 1, 1).toLocaleDateString('es-US', { month: 'short', year: '2-digit' });
                        }),
                        datasets: [{
                            label: 'Citas Nuevas',
                            data: citasNuevasData,
                            backgroundColor: highlightColor, // Usando highlightColor para Citas Nuevas
                            borderRadius: 5,
                        }, {
                            label: 'Citas Recurrentes',
                            data: citasRecurrentesData,
                            backgroundColor: secondaryColor, // Puedes cambiar a otro color si lo tienes
                            borderRadius: 5,
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: {
                            y: { beginAtZero: true, stacked: false } // 'stacked: true' para barras apiladas
                        },
                        plugins: {
                            legend: { position: 'top' },
                        }
                    }
                });
            }
        }

        // Función para renderizar la tabla de desglose de rendimiento
        function renderPerformanceTable() {
            performanceTableBody.innerHTML = ''; // Limpiar cualquier fila existente
            
            // Nombres de meses completos para mostrar en la tabla
            const monthNamesLong = {
                '01': 'Enero', '02': 'Febrero', '03': 'Marzo', '04': 'Abril', '05': 'Mayo', '06': 'Junio',
                '07': 'Julio', '08': 'Agosto', '09': 'Septiembre', '10': 'Octubre', '11': 'Noviembre', '12': 'Diciembre'
            };

            // Obtener y ordenar los datos por mes
            const sortedMonths = Object.keys(APP_DATA.rendimientoMensual).sort((a, b) => {
                const [yearA, monthA] = a.split('-').map(Number);
                const [yearB, monthB] = b.split('-').map(Number);
                if (yearA !== yearB) return yearA - yearB;
                return monthA - monthB;
            });
            
            // Crear y añadir una fila para cada mes
            if (sortedMonths.length === 0) {
                const row = document.createElement('tr');
                row.className = 'border-b border-gray-200 hover:bg-gray-50';
                row.innerHTML = `<td colspan="9" class="py-3 px-6 text-center text-gray-500">No hay datos de rendimiento disponibles.</td>`;
                performanceTableBody.appendChild(row);
            } else {
                sortedMonths.forEach(monthKey => {
                    const data = APP_DATA.rendimientoMensual[monthKey];
                    const [year, monthNum] = monthKey.split('-');
                    const monthName = monthNamesLong[monthNum];

                    const row = document.createElement('tr');
                    // Add responsive-table-stack class to the table, not each row.
                    // But if this is a table being built dynamically, we need to ensure each TD has data-label
                    row.className = 'border-b border-gray-200 hover:bg-gray-50'; 
                    row.innerHTML = `
                        <td class="py-3 px-6 text-left whitespace-nowrap font-medium" data-label="MES">${monthName} ${year}</td>
                        <td class="py-3 px-6 text-left" data-label="LEADS">${data.leads !== undefined ? data.leads : 0}</td>
                        <td class="py-3 px-6 text-left" data-label="CLIENTES">${data.clientes !== undefined ? data.clientes : 0}</td>
                        <td class="py-3 px-6 text-left" data-label="SERVICIOS">${data.serviciosVendidos !== undefined ? data.serviciosVendidos : 0}</td>
                        <td class="py-3 px-6 text-left" data-label="FACTURACIÓN">$${(data.facturacion !== undefined ? data.facturacion : 0).toLocaleString('es-US')}</td>
                        <td class="py-3 px-6 text-left" data-label="COTIZACIONES">${data.cotizacionesGeneradas !== undefined ? data.cotizacionesGeneradas : 0}</td>
                        <td class="py-3 px-6 text-left" data-label="FACTURAS">${data.facturasPagadas !== undefined ? data.facturasPagadas : 0}</td>
                        <td class="py-3 px-6 text-left" data-label="CITAS NUEVAS">${data.citasNuevas !== undefined ? data.citasNuevas : 0}</td>
                        <td class="py-3 px-6 text-left" data-label="CITAS RECURRENTES">${data.citasRecurrentes !== undefined ? data.citasRecurrentes : 0}</td>
                    `;
                    performanceTableBody.appendChild(row);
                });
            }
        }


        // ** Función de Inicialización Principal del Dashboard de Rendimiento **
        async function initPerformanceDashboard() {
            // Lógica para el menú móvil
            if (mobileMenuButton && sidebar && sidebarOverlay) {
                mobileMenuButton.addEventListener('click', () => {
                    sidebar.classList.toggle('-translate-x-full');
                    sidebarOverlay.classList.toggle('hidden');
                });
                sidebarOverlay.addEventListener('click', () => {
                    sidebar.classList.toggle('-translate-x-full');
                    sidebarOverlay.classList.toggle('hidden');
                });
            } else {
                console.warn('Alguno de los elementos del menú (botón, sidebar o overlay) no se encontró.');
            }

            // 0. Cargar los datos reales
            try {
                // Añadir un cache-buster para asegurar que siempre se obtengan los datos más recientes
                const response = await fetch('db/performance-read.php?' + new Date().getTime()); 
                const result = await response.json();
                if (result.success && result.data) {
                    APP_DATA.rendimientoMensual = result.data; // Reemplazar los datos dummy
                    showToast('Datos de rendimiento cargados exitosamente.', 'success');
                } else {
                    showToast('Error al cargar datos de rendimiento: ' + (result.message || 'Error desconocido.'), 'error');
                    APP_DATA.rendimientoMensual = {}; // Usar objeto vacío si hay error
                }
            } catch (error) {
                showToast('Error de conexión al cargar datos de rendimiento. Verifica el archivo "db/performance-read.php".', 'error');
                console.error('Error de conexión al cargar datos de rendimiento:', error);
                APP_DATA.rendimientoMensual = {}; // Usar objeto vacío en caso de error de conexión
            }

            // 1. Poblamos el selector de meses
            populateMonthSelect();
            
            // 2. Obtenemos el mes actualmente seleccionado
            const selectedMonth = monthSelect.value;
            
            // 3. Actualizamos las tarjetas de estadísticas con los datos del mes seleccionado
            updateStatCards(selectedMonth); 
            
            // 4. Renderizamos todos los gráficos
            renderFacturacionServiciosChart();
            renderLeadsClientsChart();
            renderCitasChart();
            
            // 5. Renderizamos la tabla de rendimiento (que muestra todos los meses)
            renderPerformanceTable(); 

            // 6. Añadimos un listener para actualizar las tarjetas cuando el mes cambia
            monthSelect.addEventListener('change', (event) => {
                updateStatCards(event.target.value);
                // Los gráficos y la tabla ya muestran la información consolidada de todos los meses.
                // Si quisieras que los gráficos se filtren por el mes seleccionado, tendrías que 
                // modificar las funciones de renderizado de gráficos para que acepten un parámetro de mes 
                // y filtren sus datos internamente.
            });
        }

        // Llamar a la función de inicialización cuando el DOM esté listo
        initPerformanceDashboard();

        // Asegurarse de que los íconos de Lucide se rendericen después de que todo el DOM esté cargado
        lucide.createIcons();
    });
</script>
</body>
</html>