<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit | Asistente De Respuestas Para Messenger</title>

    
    <script src="https://cdn.tailwindcss.com"></script>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css"> 
</head>
<body data-page-title="Asistente De Respuestas Para Messenger" 
      data-page-subtitle="Analiza Tus Anuncios Y Recibe Ideas Claras Para Mejorar Tus Resultados" 
      data-page-icon="bar-chart-2">

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8">
            <section id="messenger-generator" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">

                    <div class="lg:col-span-3">
                        <form id="messenger-form" class="space-y-8 bg-white p-8 rounded-xl shadow-md">
                            <div>
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                        <i class="fas fa-comment-dots mr-3 text-[var(--color-secondary)]"></i>
                                        <span class="text-[var(--color-secondary)] mr-2">PASO 1:</span> DEFINE TU ANUNCIO
                                    </h2>
                                    <p class="step-subtitle uppercase">Ingresa los datos de tu negocio, anuncio y cliente ideal.</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="space-y-6">
                                    <div>
                                        <label for="business_name" class="block font-bold text-gray-700 mb-2">Nombre De Tu Negocio</label>
                                        <input type="text" id="business_name" placeholder="Ej: Rod Cleaning Service" class="w-full p-3 bg-white border border-gray-300 rounded-lg" required>
                                    </div>
                                    <div>
                                        <label for="ad_copy" class="block font-bold text-gray-700 mb-2">Pega El Copy Del Anuncio</label>
                                        <textarea id="ad_copy" placeholder="Pega el texto exacto que tu cliente vio en el anuncio de Facebook..." class="w-full p-3 bg-white border border-gray-300 rounded-lg" rows="4" required></textarea>
                                    </div>
                                    <div>
                                        <label for="desire" class="block font-bold text-gray-700 mb-2">Deseo Profundo Del Cliente</label>
                                        <input type="text" id="desire" placeholder="Ej: Tener paz mental y tiempo libre para la familia" class="w-full p-3 bg-white border border-gray-300 rounded-lg" required>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white rounded-xl shadow-md">
                            <div class="native-video-wrapper" id="videoWrapper">
                                <div class="play-overlay" id="playOverlay">
                                    <img src="https://placehold.co/600x337/07162d/ffc857?text=VIDEO" alt="Imagen de previsualización del video" class="absolute inset-0 w-full h-full object-cover rounded-xl">
                                    <i class="fas fa-play play-icon"></i>
                                </div>
                                <video class="w-full h-full object-cover" id="videoPlayer" controlslist="nodownload nofullscreen" preload="metadata">
                                    <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                    Tu navegador no soporta la etiqueta de video.
                                </video>
                            </div>
                        </div>
                        <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                    <i class="fas fa-book mr-3 text-[var(--color-highlight)]"></i> 
                                    INSTRUCCIONES
                                </h2>
                              <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>
                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            <ul class="space-y-4 text-gray-700">
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-lightbulb"></i></span><div><strong class="text-brand-dark">Detalles Precisos:</strong> Cuanta más información proporciones sobre tu anuncio y el deseo de tu cliente, más efectiva será la automatización.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-robot"></i></span><div><strong class="text-brand-dark">Genera la Automatización:</strong> Haz clic en 'Generar Automatización' para que la IA cree los mensajes y botones.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-copy"></i></span><div><strong class="text-brand-dark">Copia y Configura:</strong> Copia cada texto con un clic y pégalo directamente en tu configuración de respuestas rápidas de Messenger.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-comment-medical"></i></span><div><strong class="text-brand-dark">Mantén la Conversación:</strong> La IA se asegura de que cada respuesta termine con una pregunta, animando al cliente a seguir interactuando.</div></li>
                            </ul>
                        </div>
                    </div>

                    <div class="lg:col-span-5 bg-white p-6 md:p-8 rounded-xl shadow-md mt-6">
                        <div class="step-header">
                             <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                <i class="fas fa-wand-magic-sparkles mr-3 text-[var(--color-secondary)]"></i>
                                <span class="text-[var(--color-secondary)] mr-2">PASO 2:</span> CREAR AUTOMATIZACIÓN
                            </h2>
                            <p class="step-subtitle uppercase">Genera una secuencia de mensajes y botones para Messenger en español e inglés.</p>
                        </div>
                        <div class="border-b border-gray-200 pb-4 mb-6"></div>
                         <div class="flex flex-col md:flex-row items-center md:justify-between gap-4">
                            <p class="text-lg text-center md:text-left text-gray-700 md:flex-1 md:pr-4 mb-0">Basado en tu anuncio y el deseo del cliente, <strong class="font-black">CLIENT3 IA</strong> creará una <b>secuencia completa de mensajes y botones</b>, diseñados para guiar a tus prospectos en Messenger y convertirlos en citas.</p>
                            <button id="generateBtn" type="submit" form="messenger-form" class="w-full md:w-auto bg-[var(--color-highlight)] text-brand-dark font-bold py-4 px-6 rounded-lg hover:scale-105 transition-transform shadow-lg text-lg flex items-center justify-center uppercase">
                                <i class="fas fa-brain mr-3"></i>
                                <span id="btn-text">Generar Automatización</span>
                                <div id="loader-container" class="hidden ml-3"></div>
                            </button>
                        </div>
                    </div>

                    <div id="result-container" class="lg:col-span-5 mt-8"></div>
                </div>
            </section>
        </div>
    </main>
</div>

<script src="files/header-manager.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    lucide.createIcons();

    // --- Lógica del Video Player ---
    const videoPlayer = document.getElementById('videoPlayer');
    const playOverlay = document.getElementById('playOverlay');
    if (videoPlayer && playOverlay) {
        videoPlayer.controls = false;
        playOverlay.addEventListener('click', () => {
            playOverlay.style.display = 'none';
            videoPlayer.controls = true;
            videoPlayer.play().catch(e => console.error("Error al reproducir video:", e));
        });
        videoPlayer.addEventListener('ended', () => {
            playOverlay.style.display = 'flex';
            videoPlayer.controls = false;
        });
    }

    // --- Lógica del Generador ---
    const form = document.getElementById('messenger-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loaderContainer = document.getElementById('loader-container');

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Generando...';
        loaderContainer.innerHTML = '<div class="w-6 h-6 border-4 border-t-transparent border-[var(--color-primary)] rounded-full animate-spin"></div>';
        loaderContainer.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        resultContainer.style.opacity = '0'; // Reinicia la opacidad para la animación

        const formData = {
            business_name: document.getElementById('business_name').value,
            ad_copy: document.getElementById('ad_copy').value,
            desire: document.getElementById('desire').value
        };

        try {
            const response = await fetch('api/API-Generador-De-Respuestas-Messenger.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.error || `El servidor respondió con un error ${response.status}.`);
            }

            const data = await response.json();
            if(data.error) {
                throw new Error(data.error);
            }
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            let errorMessage = "No se pudo generar la automatización. Por favor, revisa los datos e inténtalo de nuevo.";

            // Intenta parsear el mensaje de error para buscar el código 503
            try {
                const jsonStartIndex = error.message.indexOf('{');
                if (jsonStartIndex !== -1) {
                    const errorJsonString = error.message.substring(jsonStartIndex);
                    const errorDetails = JSON.parse(errorJsonString);
                    if (errorDetails.error && errorDetails.error.code === 503) {
                        errorMessage = "LO SENTIMOS En Este Momento, Nuestra Inteligencia Artificial Está Saturada. Por favor, Inténtalo De Nuevo En Unos Minutos.";
                    } else {
                        errorMessage += ` Detalles: ${error.message}`;
                    }
                } else {
                    errorMessage += ` Detalles: ${error.message}`;
                }
            } catch (parseError) {
                errorMessage += ` Detalles: ${error.message}`;
            }

            resultContainer.innerHTML = `<div class="bg-red-100 text-center p-4 text-red-700 rounded-lg border border-red-300"><p><strong>Error:</strong> ${errorMessage}</p></div>`;
            resultContainer.style.opacity = '1'; // Mostrar el error inmediatamente
        } finally {
            btnText.textContent = 'GENERAR AUTOMATIZACIÓN';
            loaderContainer.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        resultContainer.innerHTML = `
            <div class="ai-response p-6 md:p-8 rounded-xl shadow-md space-y-8">
                ${createSection('👋 Mensaje De Bienvenida (Saludo Inicial)', 'Este es el primer mensaje que tu cliente recibe automáticamente al hacerle clic al anuncio.', data.saludo.es, data.saludo.en)}
                ${createQASection('🤔 Pregunta Y Respuesta #1 (El Problema)', 'Para el cliente que no tiene tiempo o no sabe cómo empezar.', data.pregunta_problema, data.respuesta_problema)}
                ${createQASection('💡 Pregunta Y Respuesta #2 (La Solución)', 'Para el cliente que quiere saber cómo funciona tu servicio.', data.pregunta_solucion, data.respuesta_solucion)}
                ${createQASection('💰 Pregunta Y Respuesta #3 (El Servicio)', 'Para el cliente interesado que quiere detalles o precios.', data.pregunta_servicio, data.respuesta_servicio)}
            </div>
        `;
        setTimeout(() => { resultContainer.style.opacity = '1'; resultContainer.style.transform = 'scale(1)'; }, 100);

        resultContainer.addEventListener('click', function(e) {
            const button = e.target.closest('.copy-btn');
            if (button) {
                const textToCopy = decodeURIComponent(button.dataset.copyText);
                navigator.clipboard.writeText(textToCopy).then(() => {
                    const originalContent = button.innerHTML;
                    button.innerHTML = '<i class="fas fa-check"></i> Copiado';
                    button.classList.add('copied');
                    setTimeout(() => {
                        button.innerHTML = originalContent;
                        button.classList.remove('copied');
                    }, 2000);
                });
            }
        });
    }

    function createSection(title, subtitle, text_es, text_en) {
        return `
            <div class="result-card bg-white p-6 rounded-xl shadow-lg mb-8">
                <h3 class="text-xl font-bold text-gray-800 mb-3 flex items-center">${title}</h3>
                <p class="section-subtitle text-gray-600 mb-4">${subtitle}</p>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4">
                    <div class="ad-card bg-gray-50 p-4 rounded-lg border border-gray-200">
                        <div class="ad-card-header flex justify-between items-center mb-3">
                            <h4 class="ad-language-title text-lg font-semibold text-gray-700">🇪🇸 Español</h4>
                            <button class="copy-btn bg-[var(--color-primary)] text-white px-3 py-1 rounded-md text-sm hover:opacity-90 transition-opacity" data-copy-text="${encodeURIComponent(text_es)}"><i class="fas fa-copy mr-1"></i>Copiar Texto</button>
                        </div>
                        <div class="ad-card-body">
                            <p class="text-gray-800 leading-relaxed whitespace-pre-wrap">${text_es.replace(/\n/g, '<br>')}</p>
                        </div>
                    </div>
                    <div class="ad-card bg-gray-50 p-4 rounded-lg border border-gray-200">
                        <div class="ad-card-header flex justify-between items-center mb-3">
                            <h4 class="ad-language-title text-lg font-semibold text-gray-700">🇺🇸 English</h4>
                            <button class="copy-btn bg-[var(--color-primary)] text-white px-3 py-1 rounded-md text-sm hover:opacity-90 transition-opacity" data-copy-text="${encodeURIComponent(text_en)}"><i class="fas fa-copy mr-1"></i>Copy Text</button>
                        </div>
                        <div class="ad-card-body">
                            <p class="text-gray-800 leading-relaxed whitespace-pre-wrap">${text_en.replace(/\n/g, '<br>')}</p>
                        </div>
                    </div>
                </div>
            </div>`;
    }
    
    function createQASection(title, subtitle, pregunta, respuesta) {
        return `
            <div class="result-card bg-white p-6 rounded-xl shadow-lg mb-8">
                <h3 class="text-xl font-bold text-gray-800 mb-3 flex items-center">${title}</h3>
                <p class="section-subtitle text-gray-600 mb-4">${subtitle}</p>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4">
                    <div class="ad-card bg-gray-50 p-4 rounded-lg border border-gray-200">
                        <h4 class="ad-language-title text-lg font-semibold text-gray-700">🇪🇸 Español</h4>
                        <div class="ad-part mt-3">
                           <strong class="ad-part-title block font-extrabold text-[var(--color-secondary)] mb-2">Texto del Botón (Pregunta)</strong>
                           <div class="flex flex-col">
                               <input readonly type="text" class="w-full p-2 bg-gray-100 rounded-md text-gray-800 border border-gray-300 mb-2" value="${pregunta.es}">
                               <button class="copy-btn bg-[var(--color-secondary)] text-white font-bold text-xs py-1 px-2 rounded-md hover:bg-opacity-90 self-end" data-copy-text="${encodeURIComponent(pregunta.es)}"><i class="fas fa-copy"></i> Copiar</button>
                           </div>
                        </div>
                        <div class="ad-part mt-3">
                           <strong class="ad-part-title block font-extrabold text-[var(--color-secondary)] mb-2">Respuesta Automática</strong>
                           <div class="flex flex-col">
                               <textarea readonly class="w-full h-32 p-3 bg-gray-100 rounded-md leading-relaxed text-gray-800 resize-y border border-gray-300 mb-2">${respuesta.es}</textarea>
                               <button class="copy-btn bg-[var(--color-secondary)] text-white font-bold text-xs py-1 px-2 rounded-md hover:bg-opacity-90 self-end" data-copy-text="${encodeURIComponent(respuesta.es)}"><i class="fas fa-copy"></i> Copiar</button>
                           </div>
                        </div>
                    </div>
                    <div class="ad-card bg-gray-50 p-4 rounded-lg border border-gray-200">
                        <h4 class="ad-language-title text-lg font-semibold text-gray-700">🇺🇸 English</h4>
                        <div class="ad-part mt-3">
                           <strong class="ad-part-title block font-extrabold text-[var(--color-secondary)] mb-2">Button Text (Question)</strong>
                           <div class="flex flex-col">
                               <input readonly type="text" class="w-full p-2 bg-gray-100 rounded-md text-gray-800 border border-gray-300 mb-2" value="${pregunta.en}">
                               <button class="copy-btn bg-[var(--color-secondary)] text-white font-bold text-xs py-1 px-2 rounded-md hover:bg-opacity-90 self-end" data-copy-text="${encodeURIComponent(pregunta.en)}"><i class="fas fa-copy"></i> Copy</button>
                           </div>
                        </div>
                        <div class="ad-part mt-3">
                           <strong class="ad-part-title block font-extrabold text-[var(--color-secondary)] mb-2">Automatic Reply</strong>
                           <div class="flex flex-col">
                               <textarea readonly class="w-full h-32 p-3 bg-gray-100 rounded-md leading-relaxed text-gray-800 resize-y border border-gray-300">${respuesta.en}</textarea>
                               <button class="copy-btn bg-[var(--color-secondary)] text-white font-bold text-xs py-1 px-2 rounded-md hover:bg-opacity-90 self-end" data-copy-text="${encodeURIComponent(respuesta.en)}"><i class="fas fa-copy"></i> Copy</button>
                           </div>
                        </div>
                    </div>
                </div>
            </div>`;
    }
});
</script>
<script src="files/header-manager.js"></script>
</body>
</html>