<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit | Planificador De Objetivos Estratégicos</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
</head>
<body data-page-title="Planificador De Objetivos Estratégicos"
      data-page-subtitle="Crea Un Plan Semanal, Mensual O Trimestral Paso A Paso"
      data-page-icon="target">

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8">
            <section id="objectives-planner" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">

                    <div class="lg:col-span-3">
                        <form id="objectives-form" class="space-y-8 bg-white p-8 rounded-xl shadow-md">
                            <div>
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                        <i class="fas fa-crosshairs mr-3 text-[var(--color-secondary)]"></i>
                                        <span class="text-[var(--color-secondary)] mr-2">PASO 1:</span> DEFINE TUS METAS
                                    </h2>
                                    <p class="step-subtitle uppercase">Ingresa tus objetivos de negocio y de publicidad.</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="space-y-6">
                                    <div>
                                        <label for="main-goal" class="block font-bold text-gray-700 mb-2">¿Qué Te Gustaría Lograr Al Aplicar Este Sistema?</label>
                                        <input id="main-goal" type="text" placeholder="Ej: Conseguir 5 clientes nuevos este mes..." class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                    </div>
                                    <div>
                                        <label for="short-term-goal" class="block font-bold text-gray-700 mb-2">Objetivo A Corto Plazo (Esta Semana)</label>
                                        <input id="short-term-goal" type="text" placeholder="Ej: Dejar lista mi página y lanzar mi primer anuncio." class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                    </div>
                                    <div>
                                        <label for="medium-term-goal" class="block font-bold text-gray-700 mb-2">Objetivo A Mediano Plazo (Este Mes)</label>
                                        <input id="medium-term-goal" type="text" placeholder="Ej: Recibir mis primeros mensajes de clientes." class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                    </div>
                                    <div>
                                        <label for="long-term-goal" class="block font-bold text-gray-700 mb-2">Objetivo A Largo Plazo (En 3 Meses)</label>
                                        <input id="long-term-goal" type="text" placeholder="Ej: Tener un sistema que atrae clientes de forma constante." class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                    </div>
                                </div>
                            </div>

                            <div class="pt-8">
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                        <i class="fas fa-lightbulb mr-3 text-[var(--color-highlight)]"></i>
                                        <span class="text-[var(--color-secondary)] mr-2">PASO 2:</span> DEFINE TU EXPERIENCIA Y ESTRATEGIA
                                    </h2>
                                    <p class="step-subtitle uppercase">Selecciona tu experiencia previa y cómo planeas alcanzar tus objetivos.</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="space-y-6">
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div>
                                            <label for="prior_experience" class="block font-bold text-gray-700 mb-2">¿Has Invertido En Publicidad Antes?</label>
                                            <select id="prior_experience" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                                <option value="No, nunca he invertido">No, nunca he invertido</option>
                                                <option value="Sí, pero sin resultados claros">Sí, pero sin resultados claros</option>
                                                <option value="Sí, con buenos resultados">Sí, con buenos resultados</option>
                                            </select>
                                        </div>
                                        <div>
                                            <label for="campaign_objective" class="block font-bold text-gray-700 mb-2">Objetivo De Campaña Principal</label>
                                            <select id="campaign_objective" class="w-full p-3 bg-white border border-gray-300 rounded-lg recommended-select focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                                <option value="Recibir Mensajes">Recibir Mensajes (Recomendado)</option>
                                                <option value="Tráfico a la Página Web">Tráfico a la Página Web</option>
                                                <option value="Generación de Clientes Potenciales">Generación de Leads (Formulario)</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div>
                                        <label for="has_website" class="block font-bold text-gray-700 mb-2">¿Tienes Página Web Que Venda Por Ti 24/7?</label>
                                        <select id="has_website" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                            <option value="No, todavía no">No, todavía no</option>
                                            <option value="Sí, pero es solo informativa">Sí, pero es solo informativa</option>
                                            <option value="Sí, y está optimizada para vender">Sí, y está optimizada para vender</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label for="other_strategies" class="block font-bold text-gray-700 mb-2">¿Qué Otras Estrategias Has Utilizado?</label>
                                        <textarea id="other_strategies" placeholder="Ej: Repartir tarjetas, pedir recomendaciones, publicar en grupos..." class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" rows="3" required></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="pt-8">
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                        <i class="fas fa-money-bill-wave mr-3 text-[var(--color-secondary)]"></i>
                                        <span class="text-[var(--color-secondary)] mr-2">PASO 3:</span> DEFINE TU INVERSIÓN PUBLICITARIA
                                    </h2>
                                    <p class="step-subtitle uppercase">Detalla tu inversión disponible para publicidad.</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label for="monthly_budget" class="block font-bold text-gray-700 mb-2">Presupuesto Mensual Para Anuncios (Solo Inversión En Plataformas Como Facebook/Google) ($)</label>
                                        <input id="monthly_budget" type="number" step="1" placeholder="Ej: 150" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                    </div>
                                    <div>
                                        <label for="service-price" class="block font-bold text-gray-700 mb-2">Precio Promedio De Tu Servicio ($)</label>
                                        <input id="service-price" type="number" step="1" placeholder="Ej: 300" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" required>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white rounded-xl shadow-md">
                            <div class="native-video-wrapper" id="videoWrapper">
                                <div class="play-overlay" id="playOverlay">
                                    <img src="https://placehold.co/600x337/07162d/ffc857?text=VIDEO" alt="Imagen de previsualización del video" class="absolute inset-0 w-full h-full object-cover rounded-xl">
                                    <i class="fas fa-play play-icon"></i>
                                </div>
                                <video class="w-full h-full object-cover" id="videoPlayer" controlslist="nodownload nofullscreen" preload="metadata">
                                    <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                    Tu navegador no soporta la etiqueta de video.
                                </video>
                            </div>
                        </div>
                        <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                    <i class="fas fa-book mr-3 text-[var(--color-highlight)]"></i> 
                                    INSTRUCCIONES
                                </h2>
                              <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>
                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            <ul class="space-y-4 text-gray-700">
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-info-circle"></i></span><div><strong class="text-brand-dark">Proporciona Detalles Claros:</strong> Cuanta más información des, más preciso y útil será tu plan táctico.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-coins"></i></span><div><strong class="text-brand-dark">Sé Realista Con Tu Presupuesto:</strong> La IA te guiará para alcanzar tus metas de forma viable.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-clipboard-check"></i></span><div><strong class="text-brand-dark">Genera Tu Plan:</strong> Recibe un diagnóstico, estimaciones y un plan de acción paso a paso.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-chart-line"></i></span><div><strong class="text-brand-dark">Implementa Y Optimiza:</strong> Sigue el plan y usa las métricas clave para mejorar continuamente tus campañas.</div></li>
                            </ul>
                        </div>
                    </div>

                    <div class="lg:col-span-5 bg-white p-6 md:p-8 rounded-xl shadow-md mt-6">
                        <div class="step-header">
                             <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                <i class="fas fa-rocket mr-3 text-[var(--color-secondary)]"></i>
                                <span class="text-[var(--color-secondary)] mr-2">PASO 4:</span> GENERAR TU PLAN
                            </h2>
                            <p class="step-subtitle uppercase">Obtén un análisis detallado de tu situación y un plan de acción estratégico.</p>
                        </div>
                        <div class="border-b border-gray-200 pb-4 mb-6"></div>
                         <div class="flex flex-col md:flex-row items-center md:justify-between gap-4">
                            <p class="text-lg text-center md:text-left text-gray-700 md:flex-1 md:pr-4 mb-0">Al completar todos los campos, <strong class="font-black">CLIENT3 IA</strong>, analizará tus metas y situación actual para generarte un <b>reporte estratégico completo</b>, incluyendo un análisis de viabilidad financiera y un plan de acción paso a paso para ayudarte a conseguir tus objetivos.</p>
                            <button id="generateBtn" type="submit" form="objectives-form" class="w-full md:w-auto bg-[var(--color-highlight)] text-brand-dark font-bold py-4 px-6 rounded-lg hover:scale-105 transition-transform shadow-lg text-lg flex items-center justify-center uppercase">
                                <i class="fas fa-brain mr-3"></i>
                                <span id="btn-text">GENERAR TU PLAN ESTRATÉGICO</span>
                                <div id="loader-container" class="hidden ml-3">
                                    <div class="loader"></div>
                                </div>
                            </button>
                        </div>
                    </div>

                    <div id="result-container" class="lg:col-span-5 mt-8"></div>
                </div>
            </section>
        </div>
    </main>
</div>

<script src="files/header-manager.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    lucide.createIcons();

    // --- Lógica del Video Player ---
    const videoPlayer = document.getElementById('videoPlayer');
    const playOverlay = document.getElementById('playOverlay');
    if (videoPlayer && playOverlay) {
        videoPlayer.controls = false;
        playOverlay.addEventListener('click', () => {
            playOverlay.style.display = 'none';
            videoPlayer.controls = true;
            videoPlayer.play().catch(e => console.error("Error al reproducir video:", e));
        });
        videoPlayer.addEventListener('ended', () => {
            playOverlay.style.display = 'flex';
            videoPlayer.controls = false;
        });
    }

    // --- Lógica del Generador ---
    const form = document.getElementById('objectives-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loaderContainer = document.getElementById('loader-container');

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Creando Tu Plan Publicitario...';
        loaderContainer.classList.remove('hidden'); // Mostrar loader
        generateBtn.disabled = true;
        
        // Reiniciar el contenedor de resultados y ocultarlo para la animación
        resultContainer.innerHTML = ''; 
        resultContainer.classList.remove('show');

        const formData = {
            main_goal: document.getElementById('main-goal').value,
            short_term_goal: document.getElementById('short-term-goal').value,
            medium_term_goal: document.getElementById('medium-term-goal').value,
            long_term_goal: document.getElementById('long-term-goal').value,
            prior_experience: document.getElementById('prior_experience').value,
            campaign_objective: document.getElementById('campaign_objective').value,
            has_website: document.getElementById('has_website').value,
            other_strategies: document.getElementById('other_strategies').value,
            budget: document.getElementById('budget').value,
            service_price: document.getElementById('service-price').value
        };

        try {
            const response = await fetch('api/API-Planificador-De-Objetivos.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.error || `El servidor respondió con un error ${response.status}.`);
            }

            const data = await response.json();
            if(data.error) {
                throw new Error(data.error);
            }
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            let errorMessage = "No se pudo generar el análisis. Por favor, revisa los datos que ingresaste e inténtalo de nuevo.";

            // Intenta parsear el mensaje de error para buscar el código 503
            try {
                const jsonStartIndex = error.message.indexOf('{');
                if (jsonStartIndex !== -1) {
                    const errorJsonString = error.message.substring(jsonStartIndex);
                    const errorDetails = JSON.parse(errorJsonString);
                    if (errorDetails.error && errorDetails.error.code === 503) {
                        errorMessage = "LO SENTIMOS En Este Momento, Nuestra Inteligencia Artificial Está Saturada. Por favor, Inténtalo De Nuevo En Unos Minutos.";
                    } else {
                        errorMessage += ` Detalles: ${error.message}`;
                    }
                } else {
                    errorMessage += ` Detalles: ${error.message}`;
                }
            } catch (parseError) {
                errorMessage += ` Detalles: ${error.message}`;
            }

            resultContainer.innerHTML = `<div class="bg-red-100 text-center p-4 text-red-700 rounded-lg border border-red-300"><p><strong>Error:</strong> ${errorMessage}</p></div>`;
            resultContainer.classList.add('show'); // Mostrar el error con la animación si hay un error
        } finally {
            btnText.textContent = 'GENERAR TU PLAN ESTRATÉGICO';
            loaderContainer.classList.add('hidden'); // Ocultar loader
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        resultContainer.innerHTML = `
            <div class="ai-response p-6 md:p-8 rounded-xl shadow-md space-y-8">
                <div class="text-center">
                    <h2 class="ai-report-main-title">Tu Reporte Estratégico CLIENT3</h2>
                </div>

                <div class="ai-report-section bg-gray-50 p-6 rounded-xl shadow-sm border border-gray-200">
                    <h3 class="ad-title text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-bullseye mr-3 text-[var(--color-primary)]"></i>Análisis De Tu Situación y Metas</h3>
                    <p class="section-content-text text-gray-700 leading-relaxed">${data.analisis_objetivos}</p>
                </div>

                <div class="ai-report-section bg-gray-50 p-6 rounded-xl shadow-sm border border-gray-200">
                    <h3 class="ad-title text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-calculator mr-3 text-[var(--color-primary)]"></i>Análisis De Viabilidad Financiera</h3>
                    <p class="section-content-text text-gray-700 leading-relaxed">${data.analisis_viabilidad}</p>
                </div>
                
                <div class="ai-report-action-plan-container p-6 rounded-xl shadow-md space-y-8 bg-white border border-[var(--color-primary)]">
                    <h3 class="ai-action-plan-title text-2xl font-extrabold text-[var(--color-primary)] mb-6 flex items-center justify-center text-center"><i class="fas fa-rocket mr-3 text-[var(--color-secondary)]"></i>Tu Plan De Acción Personalizado</h3>
                    <div class="mt-6 space-y-8">
                        <div class="plan-step-item bg-gray-50 p-4 rounded-lg shadow-sm border border-gray-200 flex items-start">
                            <div class="plan-icon-wrapper bg-[var(--color-secondary)] text-white font-bold rounded-full w-10 h-10 flex items-center justify-center flex-shrink-0 text-2xl"><i class="fas fa-flag-checkered"></i></div>
                            <div class="ml-4 flex-1">
                                <h4 class="plan-step-title text-lg font-bold text-gray-800 mb-1">Primer Paso Inmediato</h4>
                                <p class="plan-step-text text-gray-700 leading-relaxed">
                                    ${data.plan_de_accion.primer_paso.replace(/\*\*(.*?)\*\*/g, '<strong class="text-[var(--color-primary)]">$1</strong>')}
                                </p>
                            </div>
                        </div>
                        <div class="plan-step-item bg-gray-50 p-4 rounded-lg shadow-sm border border-gray-200 flex items-start">
                            <div class="plan-icon-wrapper bg-[var(--color-secondary)] text-white font-bold rounded-full w-10 h-10 flex items-center justify-center flex-shrink-0 text-2xl"><i class="fas fa-calendar-week"></i></div>
                            <div class="ml-4 flex-1">
                                <h4 class="plan-step-title text-lg font-bold text-gray-800 mb-1">Enfoque a Corto Plazo (Esta Semana)</h4>
                                <p class="plan-step-text text-gray-700 leading-relaxed">
                                    ${data.plan_de_accion.corto_plazo.replace(/\*\*(.*?)\*\*/g, '<strong class="text-[var(--color-primary)]">$1</strong>')}
                                </p>
                            </div>
                        </div>
                        <div class="plan-step-item bg-gray-50 p-4 rounded-lg shadow-sm border border-gray-200 flex items-start">
                            <div class="plan-icon-wrapper bg-[var(--color-secondary)] text-white font-bold rounded-full w-10 h-10 flex items-center justify-center flex-shrink-0 text-2xl"><i class="fas fa-calendar-alt"></i></div>
                            <div class="ml-4 flex-1">
                                <h4 class="plan-step-title text-lg font-bold text-gray-800 mb-1">Enfoque a Mediano Plazo (Este Mes)</h4>
                                <p class="plan-step-text text-gray-700 leading-relaxed">
                                    ${data.plan_de_accion.mediano_plazo.replace(/\*\*(.*?)\*\*/g, '<strong class="text-[var(--color-primary)]">$1</strong>')}
                                </p>
                            </div>
                        </div>
                        <div class="plan-step-item bg-gray-50 p-4 rounded-lg shadow-sm border border-gray-200 flex items-start">
                            <div class="plan-icon-wrapper bg-[var(--color-secondary)] text-white font-bold rounded-full w-10 h-10 flex items-center justify-center flex-shrink-0 text-2xl"><i class="fas fa-calendar-check"></i></div>
                            <div class="ml-4 flex-1">
                                <h4 class="plan-step-title text-lg font-bold text-gray-800 mb-1">Enfoque a Largo Plazo (3 Meses)</h4>
                                <p class="plan-step-text text-gray-700 leading-relaxed">
                                    ${data.plan_de_accion.largo_plazo.replace(/\*\*(.*?)\*\*/g, '<strong class="text-[var(--color-primary)]">$1</strong>')}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="ai-report-section mt-8 pt-8 border-t border-gray-200">
                    <h3 class="ad-title text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-gauge-high mr-3 text-[var(--color-primary)]"></i>Métricas Clave a Monitorear</h3>
                    <p class="section-content-text text-gray-700 leading-relaxed">${data.metricas_clave}</p>
                </div>

                <div class="ai-report-section mt-8 pt-8 border-t border-gray-200">
                    <h3 class="ad-title text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-wrench mr-3 text-[var(--color-primary)]"></i>Recomendaciones para Optimización</h3>
                    <p class="section-content-text text-gray-700 leading-relaxed">${data.recomendaciones_optimizacion}</p>
                </div>
            </div>
        `;
        // Aplicar la clase 'show' después de un breve retraso para activar la animación de entrada
        setTimeout(() => { resultContainer.classList.add('show'); }, 50); 
    }
});
</script>