<?php
header('Content-Type: application/json');

// --- DEFINE TU API KEY DIRECTAMENTE AQUÍ (FUSIONADO DESDE config.php) ---
define('GEMINI_API_KEY', 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw');

// Verifica que la API Key no esté vacía.
if (empty(GEMINI_API_KEY)) {
    http_response_code(500);
    echo json_encode(['error' => 'La API Key de Gemini está vacía. Por favor, asegúrate de que el valor de GEMINI_API_KEY es correcto.']);
    exit;
}

$apiKey = GEMINI_API_KEY;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido. Utiliza POST.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar que los datos requeridos estén presentes
if (!$data || !isset($data['group_post_content']) || !isset($data['user_service']) || !isset($data['communication_tone'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos en la solicitud. Asegúrate de completar todos los campos (contenido del post, tu servicio, tono de comunicación).']);
    exit;
}

$group_post_content = htmlspecialchars($data['group_post_content']);
$user_service = htmlspecialchars($data['user_service']);
$communication_tone = htmlspecialchars($data['communication_tone']);


// --- PROMPT MAESTRO (v1.1 - Generador de Respuestas para Grupos Simplificado) ---
$prompt = "Actúa como un experto en marketing digital para negocios locales, especializado en generar confianza y vender sin vender en grupos online. Tu objetivo es crear una respuesta empática y útil a la publicación de un grupo, que sutilmente invite a la conversación privada para cerrar una venta.

--- CONTEXTO Y FILOSOFÍA ---
La clave es primero ayudar y demostrar conocimiento, generando empatía. NO se debe vender directamente en el comentario público. El objetivo es mover la conversación a un mensaje privado donde se pueda calificar y vender. La IA debe inferir el problema del post y la forma de ayudar basada en el servicio ofrecido y el contenido del post.

--- DATOS DE LA PUBLICACIÓN Y TU NEGOCIO ---
- Contenido del Post/Comentario en el Grupo (al que vas a responder): \"{$group_post_content}\"
- Tu Servicio Principal: {$user_service}
- Tono de Comunicación Deseado para la respuesta: {$communication_tone}

--- TU TAREA ESPECÍFICA ---
Genera una respuesta pública a la publicación del grupo. La respuesta debe tener las siguientes partes y estar en español ('es') y en inglés ('en'):

1.  **Empatía Inicial:** Comienza demostrando que entiendes el problema o la situación del usuario que publicó.
2.  **Ayuda/Valor (No Venta Directa):** Ofrece un consejo general o una perspectiva útil relacionada con el problema inferido del post, sin mencionar directamente tu servicio o sus precios.
3.  **Indicación de Ayuda Adicional:** Sutilmente, hazle saber que tienes experiencia o herramientas para profundizar en su problema específico o ofrecer una solución más personalizada (inferida de tu servicio).
4.  **CTA a Privado:** Termina con una invitación clara a que te escriban por mensaje privado para una ayuda más personalizada.

--- REGLAS ESTRICTAS ---
-   **No vender directamente:** Prohibido mencionar precios, paquetes, o el nombre exacto de tu servicio como una oferta en la respuesta pública.
-   **Concisión:** La respuesta debe ser de 3-5 frases, pensada para un comentario de grupo.
-   **Tono Coherente:** El tono general de la respuesta (empatía, ayuda, invitación) debe ser consistente con el 'Tono de Comunicación Deseado'.
-   **Output Bilingüe:** Genera una versión en español y otra en inglés, para la misma respuesta.

--- FORMATO DE RESPUESTA REQUERIDO ---
La respuesta DEBE ser un objeto JSON válido con la siguiente estructura:
{
    \"group_response\": {
        \"es\": \"...\",
        \"en\": \"...\"
    }
}
";

// URL de la API de Google Gemini
$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

// Inicializar cURL
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

// Manejo de errores de la solicitud cURL o respuesta HTTP
if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode([
        'error' => 'No se pudo obtener una respuesta de la IA. Posiblemente un problema de conexión o API Key.',
        'http_code' => $http_code,
        'curl_error' => $curl_error,
        'raw_response' => $response // Incluir respuesta cruda para depuración
    ]);
    exit;
}

// Decodificar la respuesta de la IA
$result = json_decode($response, true);

// Extraer el texto generado. Esto asume una estructura específica de la respuesta de la API de Gemini.
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'] ?? null;

// Limpiar el texto de posibles bloques de código Markdown
if ($generated_text) {
    $generated_text = str_replace(['```json', '```'], '', $generated_text);
}

// Intentar decodificar el JSON final.
$final_data = json_decode(trim($generated_text), true);

// Validar el formato del JSON final y su estructura
if ($final_data === null || !isset($final_data['group_response']) || !isset($final_data['group_response']['es']) || !isset($final_data['group_response']['en'])) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA devolvió un formato de JSON inválido o la estructura de datos esperada no está completa/correcta. Intenta de nuevo con tus datos.',
        'raw_ai_response_after_trim' => trim($generated_text),
        'decoded_data_debug' => $final_data // Ayuda a depurar si es JSON válido pero estructura incorrecta
    ]);
    exit;
}

// Si todo es correcto, devolver los datos generados
echo json_encode($final_data);
?>